<?php

namespace Drupal\advance_importer\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

/**
 * Importer manager interface.
 */
interface ProcessorInterface extends PluginInspectionInterface, ContainerFactoryPluginInterface {

  public function getFilePath();

  public function runImport();

  public function runExport();

  public function processBatch($contents, array &$context);

  public function finished($success, array $results, array $operations);

}
