<?php

namespace Drupal\advance_importer\Operations;

/**
 * Provides the Advance Importer plugin manager.
 */
class UpdateOperation {

  protected const BUNDLE = ['node'=>'nid','taxonomy_term'=>'tid'];

  /**
   * Update function
   * @return Boolean
   * */
  public static function execute($fields,$configuration){
    $entity_type = $configuration['entity_type'];
    $id = $fields[self::BUNDLE[$entity_type]];
    unset($fields[self::BUNDLE[$entity_type]]);
    $entity = \Drupal::entityTypeManager()->getStorage($entity_type)->load($id);
    if(empty($entity)){
      return false;
    }
    foreach ($fields as $machine_name => $value) {
      $entity->set($machine_name,$value);
    }
    $entity->save();
    return true;
  }
}
