<?php

namespace Drupal\advance_importer\Plugin\Processor;

use Drupal\advance_importer\Plugin\ProcessorBase;

/**
 * Class CSV Processor.
 *
 * @Processor(
 *   id = "csv_processor",
 *   label = @Translation("CSV")
 * )
 */
class CSV extends ProcessorBase implements ProcessorInterface {

  protected const DELIMITER = ';';

  protected const EXTENSION = '.csv';

  /**
   * @return array key|value
   * */
  public function getContents($start, $end) {
    $count = 0;
    $content = [];
    $file = fopen($this->getFilePath(), 'r');
    $header = fgetcsv($file, 0, self::DELIMITER);
    while ($csv = fgetcsv($file, 0, self::DELIMITER)) {
      if ($count >= $start && $count < $end) {
        $content[] = array_combine($header, $csv);
      }
      $count++;
    }

    fclose($file);
    return $content;
  }

  /**
   * @return array
   * */
  public function getHeader() {
    $file = fopen($this->getFilePath(), 'r');
    $header = fgetcsv($file, 0, self::DELIMITER);
    fclose($file);
    return $header;
  }

  /**
   * @return int
   * */
  public function getTotalRows() {
    $file = fopen($this->getFilePath(), 'r');
    $number_of_rows = 0;
    while ($csv = fgetcsv($file, 0, self::DELIMITER)) {
      $number_of_rows++;
    }
    fclose($file);
    return $number_of_rows;
  }

  /**
   * {@inheritdoc}
   * Export
   */
  public function parseContent($data, $FILE_EXPORT, $HEADER_KEY_VALUE_DELIMITER, $MULTI_DELIMITER, $batch_contents) {
    $filename = $this->configuration['entity_type'] . '_' . $this->configuration['entity_type_bundle'] . self::EXTENSION;
    $file = fopen($FILE_EXPORT . $filename, 'a');
    $header = fgetcsv($file, 0, self::DELIMITER);
    [$header_entity, $fields] = $data;
    if (empty($header)) {
      fputcsv($file, $header_entity, self::DELIMITER);
    }
    foreach ($fields as $field) {
      fputcsv($file, $field, self::DELIMITER);
    }
    fclose($file);
  }

  /**
   * {@inheritdoc}
   * Export
   */
  public function initFile($FILE_EXPORT) {
    $filename = $this->configuration['entity_type'] . '_' . $this->configuration['entity_type_bundle'] . self::EXTENSION;
    $file = fopen($FILE_EXPORT . $filename, 'w');
    fclose($file);
  }

}
