<?php


//$Id:

class advanced_blockqueue {
	static private $instance = null;

	/**
	 * We are implementing a singleton pattern
	 */
	private function __construct() {
	}

	public function getInstance() {
		if (is_null(self :: $instance)) {
			self :: $instance = new self;
		}
		return self :: $instance;
	}

	/**
	 * check if there is already a blockqueue for a give path
	 * if there is not blockqueue, create one and return the bqid
	 * @param string $path
	 *
	 */
	private function createBlockqueueIfNotExists($path) {
		$bqs = $this->getNodequeue($path);
		if (!$bqs) {
			$dbObject = array (
				'path' => $path
			);
			drupal_write_record('advanced_blockqueue', $dbObject);
			return db_last_insert_id('advanced_blockqueue', 'bqid');
		}
		return $bqs->bqid;
	}

	/**
	 *	Save or update a block to a blockqueue. If there's no queue yet
	 *	a queue will be generated
	 */
	public function addBlock($path, $refid, $weight = 0, $options = array ()) {
		$dbObject['path'] = drupal_get_path_alias(str_replace('$', '/', $path));

		/*$bqs = $this->getNodequeue($dbObject['path']);
		if (!$bqs) {
			drupal_write_record('advanced_blockqueue', $dbObject);
			$dbObject['bqid'] = db_last_insert_id('advanced_blockqueue', 'bqid');

		} else {
			db_query("UPDATE {advanced_blockqueue} SET path='%s' WHERE path='%s'", $dbObject['path'], $dbObject['path']);
			$dbObject['bqid'] = $bqs->bqid;
		}*/

		$dbObject['bqid'] = $this->createBlockqueueIfNotExists($dbObject['path']);

		if ($this->isInBlockQueue($dbObject['bqid'], $refid)) {
			drupal_set_message(t('This element is already in the queue'));
			return;
		}

		if (!isset ($options['reftyp'])) {
			$options['reftyp'] = ADVANCED_BLOCKQUEUE_BLOCK;
		}
		if ($options['reftyp'] == ADVANCED_BLOCKQUEUE_REFERENCE) {
			$ref_queue = $this->getNodequeue($refid);
			$dbObject['refid'] = $ref_queue->bqid;
		}
		elseif ($options['reftyp'] == ADVANCED_BLOCKQUEUE_NODE) {
			$dbObject['refid'] = $refid;
		} else {
			$dbObject['refid'] = $refid;
		}

		$dbObject['reftyp'] = $options['reftyp'];
		drupal_write_record('advanced_blockqueue_elements', $dbObject);
	}

	public function deleteBlockFromQueue($beid) {
		db_query("DELETE FROM {advanced_blockqueue_elements} WHERE beid=%d", $beid);
	}

	/**
	 * check if an element is already in the queue
	 * @param int $bqid
	 * @param int $refid
	 */
	private function isInBlockQueue($bqid, $refid) {
		$row = db_fetch_array(db_query("SELECT count(bqid) as c FROM {advanced_blockqueue_elements} WHERE bqid=%d AND refid=%d", $bqid, $refid));
		if ($row['c'] > 0) {
			return TRUE;
		}
		return FALSE;
	}

	/**
	 * saving the order of blocks -> this is mainly to get
	 * the weight of the blocks correctly
	 */
	public function saveBlocks($form) {

		$dbObject->path = drupal_get_path_alias(str_replace('$', '/', $form['values']['path']));
		$dbObject->noblocks = $form['values']['noblocks'];

		$dbObject->bqid = $this->createBlockqueueIfNotExists($dbObject->path);
		drupal_write_record('advanced_blockqueue', $dbObject, array('bqid'));

		foreach ($form['values'] as $key => $val) {
			if ($val['id'] == 'abqe') {
				db_query("UPDATE {advanced_blockqueue_elements} " .
				"SET weight = %d " .
				"WHERE beid = %d ", $val['weight'], $val['beid']);
			}
		}
	}

	/**
	 * get all the blocks for a given path and return an array with all
	 * the needed block information
	 *
	 * @param string $path - path of location of the block
	 *
	 * @param array $options - some options in an associative array
	 *
	 * possible values are:
	 * 		non_rec - if set to TRUE, the function will not check recursively for blocks
	 * 				  this can be used if a block list should be displayed
	 * 		child - the path last visited -> can be used to compare the new path with the child path
	 * 				to avoid deadly loops
	 *
	 *
	 */
	public function getBlocks($path, $options = array ()) {

		//this is for savety reasons -> stop endless loops
		static $abq_recursion_controller = 0;
		$abq_recursion_controller++;
		if ($abq_recursion_controller > 10) {
			return array ();
		}

		$path = drupal_get_path_alias($path);

		$abq = db_fetch_object(db_query("SELECT noblocks FROM {advanced_blockqueue} WHERE path='%s'",$path));
		if($abq->noblocks){
			return array();
		}

		$result = db_query("SELECT beid,abe.refid, abe.reftyp,abe.weight,ab.noblocks,ab.bqid " .
		"FROM {advanced_blockqueue} AS ab, " .
		"{advanced_blockqueue_elements} AS abe " .
		"WHERE ab.path = '%s' " .
		"AND ab.bqid = abe.bqid " .
		"ORDER BY weight desc", $path);

		$blocks = array ();
		while ($row = db_fetch_object($result)) {

			$blocks[$row->refid] = array (
				'refid' => $row->refid,
				'reftyp' => $row->reftyp,
				'weight' => $row->weight,
				'beid' => $row->beid
			);
			switch ($row->reftyp) {
				//name: is just for the list
				//title: is the actual block title
				//content: the content of the block
				case ADVANCED_BLOCKQUEUE_BLOCK :
					$row2 = db_fetch_object(db_query("SELECT * FROM {blocks} WHERE bid=%d", $row->refid));
					$tmp = module_invoke($row2->module, 'block', 'view', $row2->delta);

					if (empty ($tmp['subject'])) { //incase there's a block that was manually generated
						$tmp['subject'] = $row2->title;
					}

					// Match path if necessary
					if ($row2->pages && variable_get('advanced_blockqueue_visibility', 1) == 1) {
						if ($row2->visibility < 2) {
							$path = drupal_get_path_alias($_GET['q']);
							// Compare with the internal and path alias (if any).
							$page_match = drupal_match_path($path, $row2->pages);
							if ($path != $_GET['q']) {
								$page_match = $page_match || drupal_match_path($_GET['q'], $row2->pages);
							}
							// When $block->visibility has a value of 0, the block is displayed on
							// all pages except those listed in $block->pages. When set to 1, it
							// is displayed only on those pages listed in $block->pages.
							$page_match = !($row2->visibility xor $page_match);
						} else {
							$page_match = drupal_eval($row2->pages);
						}
					} else {
						$page_match = TRUE;
					}

					if ($page_match) { //we don't care about individual blockvisibility
						$blocks[$row->refid]['name'] = $tmp['subject'];
						$blocks[$row->refid]['title'] = $tmp['subject'];
						$blocks[$row->refid]['content'] = $tmp['content'];
					} else {
						unset ($blocks[$row->refid]);
					}

					break;
				case ADVANCED_BLOCKQUEUE_REFERENCE :
					$bq = $this->getNodequeueById($row->refid);
					$blocks[$row->refid]['name'] = $bq->path . " [Blockqueue Reference]";
					$blocks[$row->refid]['title'] = 'Blockqueue';
					$blocks[$row->refid]['subblocks'] = $this->getBlocks($bq->path);
					break;
				case ADVANCED_BLOCKQUEUE_NODE :
					$node = node_load($row->refid);
					$blocks[$row->refid]['name'] = $node->title . " [Node " . $row->refid . "]";
					$blocks[$row->refid]['title'] = l($node->title, 'node/' . $node->nid);
					$blocks[$row->refid]['content'] = $node->teaser;
					$blocks[$row->refid]['node'] = $node;
					break;
			}
		}

		if ($options['non_rec']) { //if non-recursive let's stop here
			return $blocks;
		}

		$arPath = explode("/", $path);
		unset ($arPath[sizeof($arPath) - 1]);
		$newPath = implode('/', $arPath);

		//$this->dbg("1 path: ".$path." - new Path: ".$newPath." - child: ".$options['child']." - child str replace: ".str_replace('$', '/', $options['child']));

		if (str_replace('$', '/', $options['child']) == variable_get('site_frontpage', 'node')) { // avoid a deadly loop
			return $blocks;
		}
		if (($newPath == '' || $newPath == '/') && sizeof($blocks) == 0) { //incase the path is empty -> no heritage could be found -> take frontpage
			return $this->getBlocks(variable_get('site_frontpage', 'node'), array (
				'child' => $path
			));
		}
		if (sizeof($blocks) == 0) { //incase no blockqueue is definied -> look in the parent path
			$blocks = $this->getBlocks($newPath, array (
				'child' => $path
			)); //go recursively up
		}
		return $blocks;
	}
	private function dbg($str) {
		print $str . '<br/>';
	}
	/**
	 * get a queue based on the path
	 */
	public function getNodequeue($path) {
		$result = db_query("SELECT bqid,path FROM {advanced_blockqueue} WHERE path ='%s' LIMIT 0,1", $path);
		$row = db_fetch_object($result);
		if ($row == "" || $row == NULL) {
			return FALSE;
		}
		return $row;
	}

	/**
	 * get a queue based on the bqid
	 */
	public function getNodequeueById($id) {
		$result = db_query("SELECT bqid,path FROM {advanced_blockqueue} WHERE bqid =%d LIMIT 0,1", $id);
		$row = db_fetch_object($result);
		if ($row == "" || $row == NULL) {
			return FALSE;
		}
		return $row;
	}

	/**
	 * autocomplete the path of existing block queues
	 * @param string $string
	 */
	public function autocomplete($string, $type = 'bq_ref') {
		$matches = array ();
		switch ($type) {
			case 'bq_ref' :
				$result = db_query_range("SELECT bq.path FROM {advanced_blockqueue} bq WHERE LOWER(bq.path) LIKE LOWER('%s%%')", $string, 0, 10);
				while ($abq = db_fetch_object($result)) {
					$matches[$abq->path] = check_plain($abq->path);
				}
				print drupal_to_js($matches);
				exit ();

			case 'node' :
				$result = db_query_range("SELECT title,nid FROM {node} bq WHERE LOWER(title) LIKE LOWER('%$string%')", 0, 10);
				while ($abq = db_fetch_object($result)) {
					$matches[$abq->nid] = check_plain($abq->title);
				}
				print drupal_to_js($matches);
				exit ();
		}

	}
}