<?php

namespace Drupal\advanced_email_validation;

use Drupal\Core\Config\ConfigFactoryInterface;
use EmailValidator\EmailValidator;

/**
 * Email validator service.
 */
class EmailValidatorWrapperService {

  const ADVANCED_EMAIL_VALIDATION_INVALID = 'invalid';

  const ADVANCED_EMAIL_VALIDATION_DISPOSABLE = 'disposable';

  const ADVANCED_EMAIL_VALIDATION_FREE = 'free';

  const ADVANCED_EMAIL_VALIDATION_BANNED = 'banned';

  /**
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $emailValidator;

  /**
   * Constructs an EmailValidator object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $config = $config_factory->get('advanced_email_validation.settings');
    $rules = $config->get('rules');
    $this->emailValidator = new EmailValidator([
      'checkMxRecords' => $rules[self::ADVANCED_EMAIL_VALIDATION_INVALID] !== '0',
      'checkBannedListedEmail' => $rules[self::ADVANCED_EMAIL_VALIDATION_BANNED] !== '0',
      'checkDisposableEmail' => $rules[self::ADVANCED_EMAIL_VALIDATION_DISPOSABLE] !== '0',
      'checkFreeEmail' => $rules[self::ADVANCED_EMAIL_VALIDATION_FREE] !== '0',
      'bannedList' => $config->get('banned_list'),
      'disposableList' => $config->get('disposable_list'),
      'freeList' => $config->get('free_list'),
    ]);
  }

  public function validate($email) {
    $result = $this->emailValidator->validate($email);
    return $result ? TRUE : $this->emailValidator->getErrorReason();
  }

}
