<?php

namespace Drupal\advanced_email_validation\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Check an email address against advanced_email_validation module rules.
 *
 * @Constraint(
 *   id = "AdvancedEmailValidation",
 *   label = @Translation("Advanced Email Validation", context = "Validation"),
 *   type = "string"
 * )
 */
class AdvancedEmailValidation extends Constraint {

  public $invalidEmail = 'Not a valid email address';

  public $disposableEmail = 'Disposable emails are not allowed.';

  public $freeEmail = 'Free public email providers are not allowed';

  public $bannedEmail = 'Emails using this domain are not allowed';

}
