<?php

namespace Drupal\advanced_email_validation\Plugin\Validation\Constraint;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\advanced_email_validation\EmailValidatorWrapperService;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Class AdvancedEmailValidationValidator
 */
class AdvancedEmailValidationValidator extends ConstraintValidator implements ContainerInjectionInterface {

  protected $emailValidator;

  public function __construct(EmailValidatorWrapperService $emailValidatorWrapper) {
    $this->emailValidator = $emailValidatorWrapper;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('advanced_email_validation.validator')
    );
  }

  public function validate($value, Constraint $constraint) {
    $result = $this->emailValidator->validate($value->getString());
    if ($result === 'Domain does not accept email') {
      $this->context->addViolation($constraint->invalidEmail);
    }
    if ($result === 'Domain is used by free email providers') {
      $this->context->addViolation($constraint->freeEmail);
    }
    if ($result === 'Domain is used by disposable email providers') {
      $this->context->addViolation($constraint->disposableEmail);
    }
    if ($result === 'Domain is banned') {
      $this->context->addViolation($constraint->bannedEmail);
    }
  }

}
