<?php

namespace Drupal\advanced_email_validation\Plugin\Validation\Constraint;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\advanced_email_validation\AdvancedEmailValidator;
use EmailValidator\EmailValidator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Class AdvancedEmailValidationValidator
 */
class AdvancedEmailValidationValidator extends ConstraintValidator implements ContainerInjectionInterface {

  /**
   * The Advanced email validation service.
   *
   * @var \Drupal\advanced_email_validation\AdvancedEmailValidator
   */
  protected $emailValidator;

  /**
   * @param \Drupal\advanced_email_validation\AdvancedEmailValidator $emailValidatorWrapper
   */
  public function __construct(AdvancedEmailValidator $emailValidatorWrapper) {
    $this->emailValidator = $emailValidatorWrapper;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('advanced_email_validation.validator')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function validate($value, Constraint $constraint): void {
    $result = $this->emailValidator->validate($value->getString());

    if ($result !== EmailValidator::NO_ERROR) {
      $errorMessage = $this->emailValidator->errorMessageFromCode($result);
      if (empty($errorMessage)) {
        $this->context->addViolation($constraint->defaultError);
      }
      $this->context->addViolation($errorMessage);
    }
  }

}
