<?php

namespace Drupal\advanced_file_destination\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Symfony\Component\Routing\Route;
use Drupal\Core\Routing\RouteMatch;

/**
 * Checks access for advanced file destination routes.
 */
class AdvancedFileDestinationAccess implements AccessInterface {

  /**
   * Checks access for routes requiring file destination permissions.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The currently logged in account.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function checkAccess(AccountInterface $account) {
    // Check if user has either admin permission or create directories permission
    if ($account->hasPermission('administer advanced file destination') ||
        $account->hasPermission('create advanced file destination directories')) {
      return AccessResult::allowed()
        ->cachePerPermissions();
    }

    return AccessResult::forbidden()
      ->cachePerPermissions();
  }

}
