<?php

namespace Drupal\advanced_file_destination;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\content_moderation\Entity\Handler\ModerationHandler;

/**
 * Custom moderation handler for the AFD Directory entity type.
 *
 * This handler prevents Content Moderation from applying to our entity type
 * by overriding all the relevant methods to be no-ops.
 */
class ContentModerationHandler extends ModerationHandler {

  /**
   * {@inheritdoc}
   */
  public function onPresave(EntityInterface $entity, $default_revision, $published_state) {
    // Do nothing - don't apply moderation behaviors.
    return $entity;
  }

  /**
   * {@inheritdoc}
   */
  public function enforceRevisionsBundleFormAlter(array &$form, FormStateInterface $form_state, $form_id) {
    // Do nothing - don't enforce revisions on bundle forms.
  }

  /**
   * {@inheritdoc}
   */
  public function enforceRevisionsEntityFormAlter(array &$form, FormStateInterface $form_state, $form_id) {
    // Do nothing - don't enforce revisions on entity forms.
  }

  /**
   * {@inheritdoc}
   */
  public function isModeratedEntity(EntityInterface $entity) {
    // Always return FALSE to prevent moderation.
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function isModeratedBundle($bundle_entity) {
    // Always return FALSE to prevent moderation.
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function moderationStateToPublishedStatus($state) {
    return TRUE;
  }

}