(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.directoryPreview = {
    attach: function (context, settings) {
      // Target the correct input with js-directory-name class
      once('directory-preview', '.js-directory-name', context).forEach(function(input) {
        const $input = $(input);
        const $form = $input.closest('form');
        const $preview = $form.find('.path-preview');
        const parentDir = $form.find('input[name="parent_directory"]').val();
        
        function updatePreview(value) {
          const sanitizedValue = value.replace(/[^a-z0-9_-]/gi, '_');
          let fullPath = parentDir || '';
          
          if (sanitizedValue) {
            fullPath += (fullPath.endsWith('/') ? '' : '/') + sanitizedValue;
          }
          
          $preview.text(fullPath || parentDir);
        }

        // Initial preview
        updatePreview($input.val());

        // Update on any input change
        $input.on('input', function() {
          updatePreview(this.value);
        });
      });
    }
  };

})(jQuery, Drupal, once);
