(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.directoryPreview = {
    attach: function (context, settings) {
      // Target the correct input with js-directory-name class
      once('directory-preview', '.js-directory-name', context).forEach(function(input) {
        const $input = $(input);
        const $form = $input.closest('form');
        const $preview = $form.find('.path-preview');
        const $parentPathDisplay = $form.find('.parent-directory-display code');
        const parentDir = $form.find('input[name="parent_directory"]').val();
        
        // Clean up the parent directory display if needed
        if ($parentPathDisplay.length && parentDir) {
          // Fix for doubled scheme like "public://public:/"
          let cleanedPath = parentDir;
          const schemeMatch = parentDir.match(/^([a-z]+):\/\//);
          
          if (schemeMatch) {
            const scheme = schemeMatch[1];
            // Check for doubled scheme
            const doubledSchemePattern = new RegExp(`^${scheme}:\\/\\/${scheme}:\\/`);
            if (doubledSchemePattern.test(parentDir)) {
              cleanedPath = `${scheme}://${parentDir.replace(doubledSchemePattern, '')}`;
              $parentPathDisplay.text(cleanedPath);
            }
          }
        }
        
        function updatePreview(value) {
          const sanitizedValue = value.replace(/[^a-z0-9_-]/gi, '_');
          let fullPath = parentDir || '';
          
          // Ensure we don't duplicate schemes
          if (sanitizedValue) {
            fullPath += (fullPath.endsWith('/') ? '' : '/') + sanitizedValue;
          }
          
          $preview.text(fullPath || parentDir);
        }

        // Initial preview
        updatePreview($input.val());
        
        // Update on any input change
        $input.on('input', function() {
          updatePreview(this.value);
        });
      });
    }
  };

})(jQuery, Drupal, once);
