<?php

namespace Drupal\advanced_file_destination\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\File\FileSystemInterface;

/**
 * Controller for directory-related operations.
 */
class DirectoryController extends ControllerBase {

  /**
   * Validates if a directory exists and is writable.
   */
  public function validateDirectory(Request $request) {
    $directory = $request->request->get('directory');
    $response = ['valid' => FALSE];

    if ($directory) {
      $file_system = \Drupal::service('file_system');
      try {
        // Ensure directory exists and is writable
        if ($file_system->prepareDirectory($directory, FileSystemInterface::CREATE_DIRECTORY | FileSystemInterface::MODIFY_PERMISSIONS)) {
          $response['valid'] = TRUE;
        }
      }
      catch (\Exception $e) {
        $response['error'] = $e->getMessage();
      }
    }

    return new JsonResponse($response);
  }

}
