<?php

namespace Drupal\Tests\advanced_file_destination\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;
use Drupal\Core\File\FileSystemInterface;

/**
 * Tests the Advanced File Destination UI functionality.
 *
 * @group advanced_file_destination
 */
class AdvancedFileDestinationBrowserTest extends WebDriverTestBase {

  protected static $modules = [
    'node',
    'file',
    'field_ui',
    'media',
    'advanced_file_destination',
  ];

  protected $defaultTheme = 'stark';

  protected function setUp(): void {
    parent::setUp();
    
    // Create test user
    $admin_user = $this->drupalCreateUser([
      'access content',
      'access administration pages',
      'administer site configuration',
      'administer content types',
      'administer node fields',
      'create article content',
      'access advanced file destination',
      'create advanced file destination directories',
    ]);
    $this->drupalLogin($admin_user);

    // Create test content type with file field
    $this->drupalCreateContentType(['type' => 'article']);
    $this->createFileField('field_test_file', 'node', 'article');
  }

  public function testFileUploadWithDirectorySelection() {
    $page = $this->getSession()->getPage();
    $assert_session = $this->assertSession();

    // Create test directories
    $this->container->get('file_system')->prepareDirectory('public://test_uploads', FileSystemInterface::CREATE_DIRECTORY);

    // Navigate to node creation page
    $this->drupalGet('node/add/article');

    // Select directory
    $page->selectFieldOption('Destination folder', 'public://test_uploads');
    $this->assertWaitOnAjaxRequest();

    // Upload file
    $file = current($this->getTestFiles('text'));
    $page->attachFileToField('files[field_test_file_0]', $file->uri);
    $this->assertWaitOnAjaxRequest();

    // Verify file location
    $uploaded_file = $assert_session->waitForElement('css', '.file--mime-text-plain');
    $this->assertStringContainsString('test_uploads', $uploaded_file->getAttribute('href'));
  }

  protected function assertWaitOnAjaxRequest() {
    $this->assertSession()->assertWaitOnAjaxRequest();
  }
}
