# Advanced File Destination

## INTRODUCTION

The Advanced File Destination module provides enhanced control over file upload destinations in Drupal. It allows users to:

- Select custom directories for file uploads
- Create new directories during upload
- Manage file destinations through a permission-based system
- Support for both public and private file systems

## REQUIREMENTS

This module requires the following:
- Drupal 11.x
- File (core) module
- System (core) module

## INSTALLATION

1. Install the module as you would normally install a Drupal module
2. Enable the module at `/admin/modules`
3. Configure permissions at `/admin/people/permissions`

## CONFIGURATION

1. Go to `/admin/config/media/advanced-file-destination`
2. Configure default settings:
   - Enable for specific entity types
   - Set default directory
   - Configure private file system (optional)
   - Set display preferences
3. Manage directories at `/admin/content/directories`

## PERMISSIONS

The module provides the following permissions:
- Administer advanced file destination
- Access advanced file destination
- Create advanced file destination directories
- Access private files

## MAINTAINERS

Current maintainers for Drupal 11:
- Alberto Cocchiara (Bigbabert) - https://www.drupal.org/u/bigbabert
