(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.advancedFileDestinationDirectoryForm = {
    attach: function (context, settings) {
      // Show machine name next to the name field
      once('directory-machine-name', '.js-form-item-id', context).forEach(function (element) {
        const $machineNameWrapper = $(element);
        const $nameField = $('[data-drupal-selector="edit-name"]', context);

        if ($nameField.length) {
          const $nameWrapper = $nameField.closest('.js-form-item');
          $nameWrapper.addClass('form-item--name-wrapper');
          $machineNameWrapper.addClass('form-item--machine-name');
          $machineNameWrapper.appendTo($nameWrapper);
        }
      });
    }
  };

  Drupal.behaviors.advancedFileDestinationStickyHeader = {
    attach: function (context, settings) {
      const $stickyHeader = $('.directory-form-sticky', context);
      const $pageTitle = $('.page-title h1', context);
      const offset = $stickyHeader.offset() ? .top || 0;

      // Update sticky header state on scroll
      $(window).on('scroll', function () {
        const scrollTop = $(window).scrollTop();
        if (scrollTop > offset) {
          $stickyHeader.addClass('is-sticky');
          $pageTitle.addClass('title-hidden');
        } else {
          $stickyHeader.removeClass('is-sticky');
          $pageTitle.removeClass('title-hidden');
        }
      });
    }
  };

  Drupal.behaviors.advancedFileDestinationSidebar = {
    attach: function (context, settings) {
      once('sidebar-toggle', '.meta-sidebar__trigger', context).forEach(function (trigger) {
        const $trigger = $(trigger);
        const $wrapper = $('.layout-afd-directory-form, .page-wrapper');

        // Set initial state from localStorage
        const sidebarCollapsed = localStorage.getItem('afdSidebarCollapsed') === 'true';
        if (sidebarCollapsed) {
          $wrapper.addClass('sidebar-collapsed');
          $trigger
            .addClass('is-collapsed')
            .attr({
              'aria-expanded': 'false',
              'aria-label': Drupal.t('Show sidebar'),
              'title': Drupal.t('Show sidebar panel')
            });
        }

        // Handle click event
        $trigger.on('click', function (e) {
          e.preventDefault();
          const isCollapsed = $wrapper.hasClass('sidebar-collapsed');

          $wrapper.toggleClass('sidebar-collapsed');

          $trigger
            .toggleClass('is-collapsed')
            .attr({
              'aria-expanded': !isCollapsed,
              'aria-label': isCollapsed ? Drupal.t('Hide sidebar') : Drupal.t('Show sidebar'),
              'title': isCollapsed ? Drupal.t('Hide sidebar panel') : Drupal.t('Show sidebar panel')
            });

          localStorage.setItem('afdSidebarCollapsed', !isCollapsed);
        });
      });
    }
  };

})(jQuery, Drupal, once);
