<?php

namespace Drupal\Tests\advanced_file_destination\Traits;

/**
 * Provides methods for file testing.
 */
trait FileTestTrait {

  /**
   * Creates a test file.
   *
   * @param string $filename
   *   The name of the file to create.
   *
   * @return string
   *   The filepath of the created file.
   */
  protected function createTestFile($filename) {
    $filepath = \Drupal::service('file_system')->getTempDirectory() . '/' . $filename;
    file_put_contents($filepath, $this->randomString());
    return $filepath;
  }

}
