<?php

namespace Drupal\advanced_file_destination\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\File\FileSystemInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Controller for directory-related operations.
 */
class DirectoryController extends ControllerBase {

  /**
   * The file system service.
   *
   * @var \Drupal\Core\File\FileSystemInterface
   */
  protected $fileSystem;

  /**
   * Constructs a new DirectoryController.
   *
   * @param \Drupal\Core\File\FileSystemInterface $file_system
   *   The file system service.
   */
  public function __construct(FileSystemInterface $file_system) {
    $this->fileSystem = $file_system;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('file_system')
    );
  }

  /**
   * Validates if a directory exists and is writable.
   */
  public function validateDirectory(Request $request) {
    $directory = $request->request->get('directory');
    $response = ['valid' => FALSE];

    if ($directory) {
      try {
        // Ensure directory exists and is writable.
        if ($this->fileSystem->prepareDirectory($directory, FileSystemInterface::CREATE_DIRECTORY | FileSystemInterface::MODIFY_PERMISSIONS)) {
          $response['valid'] = TRUE;
        }
      }
      catch (\Exception $e) {
        $response['error'] = $e->getMessage();
      }
    }

    return new JsonResponse($response);
  }

}
