<?php

namespace Drupal\advanced_file_destination\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure directory settings for advanced file destination.
 */
class DirectoryConfigurationForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'advanced_file_destination_directory_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['advanced_file_destination.directories'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('advanced_file_destination.directories');

    $form['directory'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Directory path'),
      '#description' => $this->t('Enter the directory path for file destination.'),
      '#default_value' => $config->get('directory'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('advanced_file_destination.directories')
      ->set('directory', $form_state->getValue('directory'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
