<?php

namespace Drupal\Tests\advanced_file_destination\Traits;

use Drupal\field\Entity\FieldConfig;
use Drupal\field\Entity\FieldStorageConfig;

/**
 * Provides common functionality for Advanced File Destination tests.
 */
trait AdvancedFileDestinationTestTrait {

  /**
   * Creates a file field.
   */
  protected function createFileField($name, $entity_type, $bundle, $settings = []) {
    $field_storage = FieldStorageConfig::create([
      'field_name' => $name,
      'entity_type' => $entity_type,
      'type' => 'file',
      'settings' => ['uri_scheme' => 'public'],
      'cardinality' => 1,
    ]);
    $field_storage->save();

    $field = FieldConfig::create([
      'field_storage' => $field_storage,
      'bundle' => $bundle,
      'label' => $this->randomMachineName(),
      'settings' => $settings,
    ]);
    $field->save();

    /** @var \Drupal\Core\Entity\EntityDisplayRepositoryInterface $display_repository */
    $display_repository = \Drupal::service('entity_display.repository');
    $display_repository->getFormDisplay($entity_type, $bundle)
      ->setComponent($name, [
        'type' => 'file_generic',
        'settings' => [],
      ])
      ->save();

    return $field;
  }

}
