(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.directoryBulkOperations = {
    attach: function (context, settings) {
      const $table = $('.directory-listing-table', context);
      const $bulkOps = $('.directory-bulk-operations', context);
      const $status = $('.directory-bulk-operations__item--status', $bulkOps);
        $status.html(Drupal.t('No items selected'));
      // Function to update bulk operations visibility
      function updateBulkOperations() {
        const selectedCount = $('.directory-listing-table input[type="checkbox"]:checked', context).length;
        if (selectedCount > 0) {
          $bulkOps.addClass('is-sticky');
          $status.html(Drupal.formatPlural(selectedCount, '1 item selected', '@count items selected'));
        } else {
          $status.html(Drupal.t('No items selected'));
          $bulkOps.removeClass('is-sticky');
        }
      }

      // Initialize
      updateBulkOperations();

      // Update on checkbox changes
      once('bulk-ops', '.directory-listing-table', context).forEach(table => {
        $(table).on('change', 'input[type="checkbox"]', updateBulkOperations);
      });
    }
  };
})(jQuery, Drupal, once);
