/* eslint-disable */
(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.advancedFileDestinationStickyHeader = {
    attach: function (context, settings) {
      const $stickyHeader = $('.directory-form-sticky', context);
      const $pageTitle = $('.page-title h1', context);
      const offset = $stickyHeader.offset() ? $stickyHeader.offset().top : 0;

      // Update sticky header state on scroll
      $(window).on('scroll', function () {
        const scrollTop = $(window).scrollTop();
        if (scrollTop > offset) {
          $stickyHeader.addClass('is-sticky');
          $pageTitle.addClass('title-hidden');
        } else {
          $stickyHeader.removeClass('is-sticky');
          $pageTitle.removeClass('title-hidden');
        }
      });
    }
  };

  Drupal.behaviors.advancedFileDestinationSidebar = {
    attach: function (context, settings) {
      once('sidebar-toggle', '.meta-sidebar__trigger', context).forEach(function (trigger) {
        const $trigger = $(trigger);
        const $wrapper = $('.layout-afd-directory-form, .page-wrapper');

        // Set initial state from localStorage
        const sidebarCollapsed = localStorage.getItem('afdSidebarCollapsed') === 'true';
        if (sidebarCollapsed) {
          $wrapper.addClass('sidebar-collapsed');
          $trigger
            .addClass('is-collapsed')
            .attr({
              'aria-expanded': 'false',
              'aria-label': Drupal.t('Show sidebar'),
              'title': Drupal.t('Show sidebar panel')
            });
        }

        // Handle click event
        $trigger.on('click', function (e) {
          e.preventDefault();
          const isCollapsed = $wrapper.hasClass('sidebar-collapsed');

          $wrapper.toggleClass('sidebar-collapsed');

          $trigger
            .toggleClass('is-collapsed')
            .attr({
              'aria-expanded': !isCollapsed,
              'aria-label': isCollapsed ? Drupal.t('Hide sidebar') : Drupal.t('Show sidebar'),
              'title': isCollapsed ? Drupal.t('Hide sidebar panel') : Drupal.t('Show sidebar panel')
            });

          localStorage.setItem('afdSidebarCollapsed', !isCollapsed);
        });
      });
    }
  };

  Drupal.behaviors.advancedFileDestinationDirectoryPath = {
    attach: function (context, settings) {
      once('directory-name', '[name="name"], [name="path"]', context).forEach(function (input) {
        input.addEventListener('input', function () {
            // Sanitize the value of the first input
            const sanitized = input.value
            .toLowerCase()
            .replace(/[^a-z0-9_\/-]/gi, '_')
            .replace(/[\s_]+/g, '-');

            // Find the other input [name="path"] in the same form or wrapper
          const pathInput = input
            .closest('form, .form-wrapper').querySelector('[name="path"]');

          if (pathInput) {
            pathInput.value = sanitized;
          }
        });
      });
    }
  };

})(jQuery, Drupal, once);
