/* eslint-disable */
(function ($, Drupal, drupalSettings, once) {
  'use strict';

  let isProcessing = false;

  function updateFormElements(directory) {
    return new Promise((resolve) => {
      if (!directory || isProcessing) {
        resolve();
        return;
      }

      isProcessing = true;

      const formData = new FormData();
      formData.append('directory', directory);
      formData.append('parent_directory', directory);
      //console.log('Updating directory:', directory);
      //console.log('adfInstanceId:', $('.adf_instance_id').val());
      formData.append('adf_instance_id', $('.adf_instance_id').val());
      fetch(Drupal.url('advanced-file-destination/ajax/update-state'), {
        method: 'POST',
        body: formData,
        credentials: 'same-origin',
        headers: {
          'X-CSRF-Token': drupalSettings.advanced_file_destination ? drupalSettings.advanced_file_destination.csrfToken : '',
        }
      })
      .then(response => response.json())
      .then(data => {
          if (data.status === 'success') {
                let $href = $('#modal-create-directory-button').attr('href');
                if ($href) {
                  // Update the href attribute with the new directory
                  $href = $href.replace(/([?&]parent_directory=)[^&]*/, `$1${encodeURIComponent(directory)}`);
                  // If the parent_directory parameter is not present, add it
                  if (!$href.includes('parent_directory=')) {
                    const joinChar = $href.includes('?') ? '&' : '?';
                    $href += `${joinChar}parent_directory = ${encodeURIComponent(directory)}`;
                  }
                  $('#modal-create-directory-button').attr('href', $href);
                }
                if($('.messages__content').length > 0 && $('.messages__content').find('.selected_dir').length > 0) {
                  // update text after Directory selected: if present
                  $('.messages__content').find('.selected_dir').text(directory);
                }
                // Update managed file elements
                $('.js-form-managed-file').each(function () {
                  $(this).attr('data-upload-location', directory);
                  $(this).find('input[type="file"]').attr('data-upload-location', directory);
                });
                triggerFormUpdates(directory);

                // Append (current selection) to the selected element label
                const $selectedOption = $('.js-advanced-file-destination-select').find('option:selected');
                const selectedLabel = $selectedOption.text();
                const updatedLabel = selectedLabel.replace(/ \([^)]+\)$/, '') + ' (' + Drupal.t('current selection') + ')';
                // Remove the (current selection) label from not selected options
                $('.js-advanced-file-destination-select option').not(':selected').each(function () {
                  const $option = $(this);
                  const optionLabel = $option.text();
                  const updatedOptionLabel = optionLabel.replace(' (' + Drupal.t('current selection') + ')', '');
                  $option.text(updatedOptionLabel);
                });
                $selectedOption.text(updatedLabel);

                // For non-modal context, trigger change which will use normal behavior
                // Trigger native change events
                $('.js-advanced-file-destination-select').trigger('directory_change');

                isProcessing = false;
                // Resolve the promise after successful update
                //console.log('Directory updated:', directory);
                resolve();
                return;
            } else {
            console.error('Error updating even if success directory:', data.message);
            isProcessing = false;
            resolve();
          }
      })
      .catch(error => {
        console.error('Error updating directory state:', error);
        // Enable button elements to allow further interactions
        $('#modal-create-directory-button')
        .off('mousedown.disableModal')
        .removeClass('is-disabled');
        $('input[type="file"]')
        .off('mousedown.disableModal')
        .removeClass('is-disabled');
        isProcessing = false;
        resolve();
        return;
      })
      .then(() => {
      });
    });
  }

  function triggerFormUpdates(directory) {
    // Update any media library fields
    $('.media-library-add-form input[type="file"]').each(function () {
      const $form = $(this).closest('form');
      const $uploadLocation = $form.find('[data-drupal-selector="edit-upload-location"]');
      if ($uploadLocation.length) {
        $uploadLocation.val(directory);
      }
    });

    // Force update for hidden media upload location fields
    $('input[name="upload_location"]').val(directory);
    $('#parent_directory-id').val(directory);
  }

  Drupal.behaviors.directorySelection = {
    attach: function (context, settings) {
      // Use consistent selector for directory select elements
      once('directory-selection', 'select[name="advanced_file_destination[directory]"]', context).forEach(function (element) {
        const $element = $(element);
        $element.addClass('js-advanced-file-destination-select');

        $element.on('change', async function (e) {

          e.preventDefault();
          e.stopImmediatePropagation();

          if (!isProcessing) {
            // Update the directory state
            let directorySelected = $(this).val();
            await updateFormElements(directorySelected);
          }
        });
      });
    }
  };

})(jQuery, Drupal, drupalSettings, once);
