/**
 * @file
 * JavaScript for real-time directory path preview updates.
 */

(function ($, Drupal) {
  /**
   * Behavior for updating directory path preview in real-time.
   */
  Drupal.behaviors.directoryPathPreview = {
    attach: function (context, settings) {
      // Use Drupal's core once() function instead of jQuery once plugin
      const container = once('directory-preview', '.directory-settings-container', context);

      if (container.length) {
        // Get elements inside the container
        const $streamWrapper = $('select[name="stream_wrapper"]', context);
        const $subdirectory = $('input[name="subdirectory"]', context);
        const $preview = $('#default-directory-preview', context);
        const $hiddenField = $('input[name="default_directory"]', context);

        // Function to update the preview
        function updatePreview() {
          const stream = $streamWrapper.val();
          let subdir = $subdirectory.val().trim();

          // Remove leading and trailing slashes
          subdir = subdir.replace(/^\/+|\/+$/g, '');

          // Build the full path
          let fullPath = stream;
          if (subdir) {
            fullPath += subdir;
          }

          // Update the preview and hidden field
          $preview.text(fullPath);
          $hiddenField.val(fullPath);

          // For debugging
          console.log('Updated path preview to: ' + fullPath);
        }

        // Bind events
        $streamWrapper.on('change', updatePreview);
        $subdirectory.on('input', updatePreview);

        // Initialize on page load
        updatePreview();
      }
    }
  };

})(jQuery, Drupal);
