/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var _wp = wp,
    blocks = _wp.blocks,
    data = _wp.data,
    element = _wp.element,
    components = _wp.components,
    editor = _wp.editor;
var registerBlockType = blocks.registerBlockType;
var dispatch = data.dispatch,
    select = data.select;
var Fragment = element.Fragment,
    useState = element.useState,
    useEffect = element.useEffect;
var PanelBody = components.PanelBody,
    BaseControl = components.BaseControl,
    Icon = components.Icon,
    RangeControl = components.RangeControl,
    IconButton = components.IconButton,
    Toolbar = components.Toolbar,
    SelectControl = components.SelectControl,
    CheckboxControl = components.CheckboxControl,
    Grid = components.Grid;
var InnerBlocks = editor.InnerBlocks,
    RichText = editor.RichText,
    InspectorControls = editor.InspectorControls,
    PanelColorSettings = editor.PanelColorSettings,
    MediaUpload = editor.MediaUpload,
    MediaUploadCheck = editor.MediaUploadCheck,
    BlockControls = editor.BlockControls;

var __ = Drupal.t;

var el = wp.element.createElement;

var sectionBreakH2 = {
  title: __('Section Break (H2)'),
  description: __('H2 is used as Section Heading'),
  icon: 'heading',
  attributes: {
    title: {
      type: 'string'
    },

    backgroundflag: {
      type: 'string'
    }
  },

  edit: function edit(_ref) {
    var attributes = _ref.attributes,
        setAttributes = _ref.setAttributes,
        isSelected = _ref.isSelected;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;

    return React.createElement(
      Fragment,
      null,
      React.createElement(RichText, {
        identifier: 'title',
        tagName: 'h2',
        value: title,
        placeholder: __('Section Break (H2)'),
        onChange: function onChange(title) {
          setAttributes({
            title: title
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref2) {
    var attributes = _ref2.attributes;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;


    return React.createElement(
      'div',
      { className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        title && React.createElement('h2', { dangerouslySetInnerHTML: { __html: title } })
      )
    );
  }
};

var customHeading = {
  title: __('Custom Heading'),
  description: __('Custom heading block with background options'),
  icon: 'heading',
  attributes: {
    title: {
      type: 'string'
    },

    backgroundflag: {
      type: 'string'
    }
  },

  edit: function edit(_ref3) {
    var attributes = _ref3.attributes,
        setAttributes = _ref3.setAttributes,
        isSelected = _ref3.isSelected;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;

    return React.createElement(
      Fragment,
      null,
      React.createElement(RichText, {
        identifier: 'title',
        tagName: 'h1',
        value: title,
        placeholder: __('Custom Heading H1'),
        onChange: function onChange(title) {
          setAttributes({
            title: title
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref4) {
    var attributes = _ref4.attributes;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;


    return React.createElement(
      'div',
      { className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        title && React.createElement('h1', { dangerouslySetInnerHTML: { __html: title } })
      )
    );
  }
};

var highlightedTexticon = el('svg', { width: 20, height: 20, viewBox: "0 0 512 512" }, el('path', { d: "M451.4692,125.4041,380.5656,54.5016a13.1093,13.1093,0,0,0-17.7457-.7327L164.9985,221.3722,284.6018,340.9744l167.6-197.8225A13.11,13.11,0,0,0,451.4692,125.4041Z" }), el('rect', { width: 172.7608, height: 41.0143, x: 171.2274, y: 227.8569, transform: "translate(-166.0416 227.6148) rotate(-45)" }), el('path', { d: "M94.5521,363.7306,142.2413,411.42c18.5232-11.008,40.65-15.58,63.1619-17.3911l-93.46-93.46C110.1316,323.08,105.56,345.2073,94.5521,363.7306Z" }), el('path', { d: "M58.6143,403.6279a6.5743,6.5743,0,0,0-1.2732,7.5013l22.3748,46.4866a6.5746,6.5746,0,0,0,10.5723,1.7965l31.4111-31.4111L77.9706,384.2726Z" }));
var highlightedText = {
  title: __('Highlighted text'),
  description: __(''),
  icon: highlightedTexticon,
  attributes: {
    title: {
      type: 'string'
    },
    textcopy: {
      type: 'string'
    },

    layoutoption: {
      type: 'string'
    }
  },

  edit: function edit(_ref5) {
    var attributes = _ref5.attributes,
        setAttributes = _ref5.setAttributes,
        isSelected = _ref5.isSelected;
    var title = attributes.title,
        textcopy = attributes.textcopy,
        layoutoption = attributes.layoutoption;

    return React.createElement(
      Fragment,
      null,
      React.createElement(RichText, {
        identifier: 'title',
        tagName: 'h3',
        value: title,
        placeholder: __('Highlighted Text Title'),
        onChange: function onChange(title) {
          setAttributes({
            title: title
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(RichText, {
        identifier: 'Text Copy',
        tagName: 'p',
        value: textcopy,
        placeholder: __('Highlighted Text Copy'),
        onChange: function onChange(textcopy) {
          setAttributes({
            textcopy: textcopy
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'layout Options',
            value: layoutoption,
            options: [{ label: '⅓ title text + ⅔ body text side by side', value: 'large_text' }, { label: '⅔ title text + ⅓ body text side by side', value: 'large_title' }, { label: 'Stacked title and body text', value: 'stacked' }],
            onChange: function onChange(layoutoption) {
              setAttributes({
                layoutoption: layoutoption
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref6) {
    var attributes = _ref6.attributes;
    var title = attributes.title,
        textcopy = attributes.textcopy,
        layoutoption = attributes.layoutoption;


    return React.createElement(
      'div',
      { className: '' + ((typeof layoutoption === 'undefined' ? 'undefined' : _typeof(layoutoption)) !== undefined ? layoutoption : "large_text") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        title && React.createElement('div', { className: 'title h3', dangerouslySetInnerHTML: { __html: title } }),
        textcopy && React.createElement('p', { dangerouslySetInnerHTML: { __html: textcopy } })
      )
    );
  }
};

var imgGridicon = el('svg', { width: 20, height: 20 }, el('path', { d: "M0,4 L4,4 L4,0 L0,0 L0,4 L0,4 Z M6,16 L10,16 L10,12 L6,12 L6,16 L6,16 Z M0,16 L4,16 L4,12 L0,12 L0,16 L0,16 Z M0,10 L4,10 L4,6 L0,6 L0,10 L0,10 Z M6,10 L10,10 L10,6 L6,6 L6,10 L6,10 Z M12,0 L12,4 L16,4 L16,0 L12,0 L12,0 Z M6,4 L10,4 L10,0 L6,0 L6,4 L6,4 Z M12,10 L16,10 L16,6 L12,6 L12,10 L12,10 Z M12,16 L16,16 L16,12 L12,12 L12,16 L12,16 Z" }));
var imageGrid_TEMPLATE = [['core/columns', {}, [['core/column', {}, [['core/image']]], ['core/column', {}, [['core/image']]], ['core/column', {}, [['core/image']]]]], ['core/columns', {}, [['core/column', {}, [['core/image']]], ['core/column', {}, [['core/image']]], ['core/column', {}, [['core/image']]]]]];
var imageGrid_ALLOWED_BLOCKS = ['core/image'];
var imageGrid = {
  title: __('Image Grid'),
  description: __('Image Grid of six'),
  icon: imgGridicon,
  edit: function edit(_ref7) {
    var attributes = _ref7.attributes,
        setAttributes = _ref7.setAttributes,
        isSelected = _ref7.isSelected;


    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'div',
        { className: 'image-grid-wrapper' },
        React.createElement(
          'div',
          { className: 'image-grid' },
          React.createElement(InnerBlocks, { template: imageGrid_TEMPLATE, templateLock: 'all', allowedBlocks: imageGrid_ALLOWED_BLOCKS })
        )
      )
    );
  },
  save: function save(_ref8) {
    var attributes = _ref8.attributes;

    return React.createElement(
      'div',
      { className: 'image-grid-wrapper' },
      React.createElement(
        'div',
        { className: 'image-grid' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var CustomTextBlock = {
  title: __('Custom Text Block'),
  description: __(''),
  icon: 'menu',
  attributes: {
    title: {
      type: 'string'
    },

    backgroundflag: {
      type: 'string'
    }
  },
  edit: function edit(_ref9) {
    var attributes = _ref9.attributes,
        setAttributes = _ref9.setAttributes,
        isSelected = _ref9.isSelected;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;

    return React.createElement(
      Fragment,
      null,
      React.createElement(RichText, {
        identifier: 'title',
        tagName: 'h3',
        value: title,
        placeholder: __('Text Block Title'),
        onChange: function onChange(title) {
          setAttributes({
            title: title
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(InnerBlocks, null),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref10) {
    var attributes = _ref10.attributes;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;


    return React.createElement(
      'div',
      { className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        title && React.createElement('div', { className: 'title h3', dangerouslySetInnerHTML: { __html: title } }),
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var textImageSlidericon = el('svg', { width: 20, height: 20 }, el('path', { d: "M 0 3 L 0 4 L 1 4 L 1 14 L 0 14 L 0 15 L 2 15 L 2 3 L 0 3 z M 3 3 L 3 15 L 17 15 L 17 3 L 3 3 z M 18 3 L 18 15 L 20 15 L 20 14 L 19 14 L 19 4 L 20 4 L 20 3 L 18 3 z M 4 4 L 16 4 L 16 14 L 4 14 L 4 4 z M 5 17 L 5 18 L 7 18 L 7 17 L 5 17 z M 9 17 L 9 18 L 11 18 L 11 17 L 9 17 z M 13 17 L 13 18 L 15 18 L 15 17 L 13 17 z" }));
var textImageSlide_ALLOWED_BLOCKS = ['core/heading', 'core/paragraph', 'core/button', 'core/image'];
var textImageSlide_TEMPLATE = [['core/columns', {}, [['core/column', {}, [['core/paragraph', { className: "slide-heading h3", fontSize: "Large", placeholder: "Slide Heading" }], ['core/paragraph', { placeholder: "Slide Text" }], ['core/button', { customBackgroundColor: "transparent" }]]], ['core/column', {}, [['core/image']]]]]];
var TextImageSlide = {
  title: __('Text + image slide'),
  description: __('Single Slide of Text + Image'),
  icon: textImageSlidericon,
  parent: ['example/textimageslider-block'],
  edit: function edit(_ref11) {
    var attributes = _ref11.attributes,
        setAttributes = _ref11.setAttributes,
        isSelected = _ref11.isSelected;


    return React.createElement(
      Fragment,
      null,
      React.createElement(InnerBlocks, { template: textImageSlide_TEMPLATE, allowedBlocks: textImageSlide_ALLOWED_BLOCKS, templateLock: 'all' })
    );
  },
  save: function save(_ref12) {
    var attributes = _ref12.attributes;

    return React.createElement(
      'div',
      null,
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(InnerBlocks.Content, { 'aria-roledescription': 'Text Image Slide', role: 'group' })
      )
    );
  }
};

var textImageSlider_ALLOWED_BLOCKS = ['example/textimageslide-block'];
var textImageSlider_TEMPLATE = [['example/textimageslide-block']];
var TextImageSlider = {
  title: __('Text + image slider - Repeater'),
  description: __('Slider of Text + Image'),
  icon: textImageSlidericon,
  edit: function edit(_ref13) {
    var attributes = _ref13.attributes,
        setAttributes = _ref13.setAttributes,
        isSelected = _ref13.isSelected;

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Text + Image Slider'
      ),
      React.createElement(InnerBlocks, { allowedBlocks: textImageSlider_ALLOWED_BLOCKS, template: textImageSlider_TEMPLATE })
    );
  },
  save: function save(_ref14) {
    var attributes = _ref14.attributes;

    return React.createElement(
      'div',
      { 'aria-roledescription': 'carousel', 'aria-label': 'Text Image Slider' },
      React.createElement(
        'nav',
        { className: 'slider-navigation' },
        React.createElement(
          'button',
          { className: 'prev', 'aria-controls': 'text-image-slider', 'data-slide': 'prev' },
          ' ',
          React.createElement(
            'span',
            { className: 'visually-hidden-focusable' },
            'Previous Slide'
          ),
          ' '
        ),
        React.createElement(
          'button',
          { className: 'next', 'aria-controls': 'text-image-slider', 'data-slide': 'next' },
          ' ',
          React.createElement(
            'span',
            { className: 'visually-hidden-focusable' },
            'Next Slide'
          ),
          ' '
        )
      ),
      React.createElement(
        'div',
        { className: 'slider-wrapper', 'data-ride': 'carousel', id: 'text-image-slider' },
        React.createElement(InnerBlocks.Content, { 'aria-roledescription': 'Text Image Slide', role: 'group' })
      )
    );
  }
};

var featuredMediaicon = el('svg', { width: 20, height: 20, fill: '#ffffff', stroke: "#000" }, el('path', { d: "M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z" }), el('circle', { cx: "12", cy: "13", r: "4" }));
var featuredMedia_ALLOWED_BLOCKS = ['drupalmedia/drupal-media-entity', 'core/embed'];
var featuredMedia_TEMPLATE = [['core/image', { align: "center" }]];
var CustomFeaturedMediaBlock = {
  title: __('Featured Media'),
  description: __(''),
  icon: featuredMediaicon,
  attributes: {
    widthflag: {
      type: 'string'
    }
  },
  edit: function edit(_ref15) {
    var attributes = _ref15.attributes,
        setAttributes = _ref15.setAttributes,
        isSelected = _ref15.isSelected;
    var widthflag = attributes.widthflag;

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Featured Media Block:'
      ),
      React.createElement(InnerBlocks, { allowedBlocks: featuredMedia_ALLOWED_BLOCKS, template: featuredMedia_TEMPLATE }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Width Option',
            value: widthflag,
            options: [{ label: 'Constrained', value: 'constrained' }, { label: 'Full Width', value: 'full_width' }],
            onChange: function onChange(widthflag) {
              setAttributes({
                widthflag: widthflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref16) {
    var attributes = _ref16.attributes;
    var widthflag = attributes.widthflag;


    return React.createElement(
      'div',
      { className: '' + ((typeof widthflag === 'undefined' ? 'undefined' : _typeof(widthflag)) !== undefined ? widthflag : "constrained") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var featuredMedia_Sidebyside_TEMPLATE = [['core/columns', {}, [['core/column', {}, [['core/image', { caption: " " }]]], ['core/column', {}, [['core/image', { caption: " " }]]]]]];
var featuredMedia_type1_TEMPLATE = [['core/group', {}, [['core/columns', {}, [['core/column', {}, [['core/image', { caption: " " }]]], ['core/column', {}, [['core/image', { caption: " " }]]]]], ['core/image', { caption: " " }]]]];
var featuredMedia_type2_TEMPLATE = [['core/group', {}, [['core/image', { caption: " " }], ['core/columns', {}, [['core/column', {}, [['core/image', { caption: " " }]]], ['core/column', {}, [['core/image', { caption: " " }]]]]]]]];

var featuredMedia_type3_TEMPLATE = [['core/group', {}, [['core/image', { caption: " " }], ['core/columns', {}, [['core/column', {}, [['core/image', { caption: " " }]]], ['core/column', {}, [['core/image', { caption: " " }]]]]], ['core/image', { caption: " " }]]]];

var key = 0;
var imageMosaicBlock = {
  title: __('Image Mosaic'),
  description: __(''),

  attributes: {
    layoutoption: {
      type: 'string'
    }
  },
  edit: function edit(_ref17) {
    var attributes = _ref17.attributes,
        setAttributes = _ref17.setAttributes,
        isSelected = _ref17.isSelected;
    var layoutoption = attributes.layoutoption;

    var initialLayout = void 0;


    if (!layoutoption) {
      setAttributes({
        layoutoption: "side_by_side"
      });
    }

    switch (layoutoption) {
      case "side_by_side":
        initialLayout = featuredMedia_Sidebyside_TEMPLATE;
        break;
      case "type1":
        initialLayout = featuredMedia_type1_TEMPLATE;
        break;
      case "type2":
        initialLayout = featuredMedia_type2_TEMPLATE;
        break;
      case "type3":
        initialLayout = featuredMedia_type3_TEMPLATE;
        break;
      default:
        initialLayout = featuredMedia_Sidebyside_TEMPLATE;
    };

    var _useState = useState(initialLayout),
        _useState2 = _slicedToArray(_useState, 2),
        layout = _useState2[0],
        setLayout = _useState2[1];

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Image Mosaic:'
      ),
      React.createElement(InnerBlocks, { template: layout, templateLock: 'all', key: key }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Layout Option',
            value: layoutoption,
            options: [{ label: 'Side by Side Images', value: 'side_by_side' }, { label: '⅓ + ⅔ images above full width image', value: 'type1' }, { label: 'Full width image above ⅔ + ⅓ images', value: 'type2' }, { label: 'Full width + two half width + full width', value: 'type3' }],
            onChange: function onChange(layoutoption) {
              setAttributes({
                layoutoption: layoutoption
              });
              key = ++key;

              switch (layoutoption) {
                case "side_by_side":
                  setLayout(featuredMedia_Sidebyside_TEMPLATE);
                  break;
                case "type1":
                  setLayout(featuredMedia_type1_TEMPLATE);
                  break;
                case "type2":
                  setLayout(featuredMedia_type2_TEMPLATE);
                  break;
                case "type3":
                  setLayout(featuredMedia_type3_TEMPLATE);
                  break;
                default:
                  setLayout(featuredMedia_Sidebyside_TEMPLATE);
              };
            }
          })
        )
      )
    );
  },
  save: function save(_ref18) {
    var attributes = _ref18.attributes;
    var layoutoption = attributes.layoutoption;

    var layoutclassname = void 0;
    if (layoutoption) {
      layoutclassname = layoutoption;
    } else {
      layoutclassname = "side_by_side";
    }
    return React.createElement(
      'div',
      { className: layoutclassname },
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var mediarepeater_icon = el('svg', { width: 20, height: 20, viewBox: "0 0 32 32" }, el('path', { d: "M6,0H2C0.895,0,0,0.896,0,2v4c0,1.105,0.895,2,2,2h4c1.105,0,2-0.895,2-2V2C8,0.896,7.105,0,6,0z M6,6H2V2   h4V6z" }), el('path', { d: "M18,0h-4c-1.105,0-2,0.896-2,2v4c0,1.105,0.895,2,2,2h4c1.104,0,2-0.895,2-2V2C20,0.896,19.104,0,18,0z    M18,6h-4V2h4V6z" }), el('path', { d: "M30,0h-4c-1.105,0-2,0.896-2,2v4c0,1.105,0.895,2,2,2h4c1.104,0,2-0.895,2-2V2C32,0.896,31.104,0,30,0z    M30,6h-4V2h4V6z" }), el('path', { d: "M6,12H2c-1.105,0-2,0.895-2,2v4c0,1.105,0.895,2,2,2h4   c1.105,0,2-0.895,2-2v-4C8,12.896,7.105,12,6,12z M6,18H2v-4h4V18z" }), el('path', { d: "M18,12h-4c-1.105,0-2,0.895-2,2v4c0,1.105,0.895,2,2,2h4   c1.104,0,2-0.895,2-2v-4C20,12.896,19.104,12,18,12z M18,18h-4v-4h4V18z" }), el('path', { d: "M30,12h-4c-1.105,0-2,0.895-2,2v4c0,1.105,0.895,2,2,2h4   c1.104,0,2-0.895,2-2v-4C32,12.896,31.104,12,30,12z M30,18h-4v-4h4V18z" }), el('path', { d: "M6,24H2c-1.105,0-2,0.895-2,2v4c0,1.105,0.895,2,2,2h4   c1.105,0,2-0.895,2-2v-4C8,24.896,7.105,24,6,24z M6,30H2v-4h4V30z" }), el('path', { d: "M18,24h-4c-1.105,0-2,0.895-2,2v4c0,1.105,0.895,2,2,2h4   c1.104,0,2-0.895,2-2v-4C20,24.896,19.104,24,18,24z M18,30h-4v-4h4V30z" }), el('path', { d: "M30,24h-4c-1.105,0-2,0.895-2,2v4c0,1.105,0.895,2,2,2h4   c1.104,0,2-0.895,2-2v-4C32,24.896,31.104,24,30,24z M30,30h-4v-4h4V30z" }));
var teamMember_ALLOWED_BLOCKS = ['core/image', 'core/paragraph'];
var teamMember_TEMPLATE = [['drupalmedia/drupal-media-entity', {}], ['core/paragraph', { placeholder: 'Title', className: "title" }], ['core/paragraph', { placeholder: 'Subhead', className: "subhead" }]];

var teamMemberBlock = {
  title: __('Media Repeater Item'),
  parent: ['core/columns'],
  icon: mediarepeater_icon,
  description: __(''),
  attributes: {},
  edit: function edit(_ref19) {
    var attributes = _ref19.attributes,
        setAttributes = _ref19.setAttributes,
        isSelected = _ref19.isSelected;

    return React.createElement(
      'div',
      null,
      React.createElement(InnerBlocks, { allowedBlocks: teamMember_ALLOWED_BLOCKS, template: teamMember_TEMPLATE, templateLock: 'all' })
    );
  },
  save: function save(_ref20) {
    var attributes = _ref20.attributes;

    return React.createElement(
      'div',
      { className: 'column' },
      React.createElement(InnerBlocks.Content, null)
    );
  }
};
var mediaRepeaterBlock_ALLOWED_BLOCKS = ['example/teammember-block'];
var mediaRepeater_TEMPLATE = [['example/teammember-block'], ['example/teammember-block'], ['example/teammember-block']];
var mediaRepeaterBlock = {
  title: __('Media Repeater Grid'),
  description: __(''),
  icon: mediarepeater_icon,
  attributes: {},
  edit: function edit(_ref21) {
    var attributes = _ref21.attributes,
        setAttributes = _ref21.setAttributes,
        isSelected = _ref21.isSelected;

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Media Repeater Grid:'
      ),
      React.createElement(
        'div',
        null,
        React.createElement(InnerBlocks, { allowedBlocks: mediaRepeaterBlock_ALLOWED_BLOCKS, template: mediaRepeater_TEMPLATE })
      ),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(PanelBody, { title: __('Block Settings') })
      )
    );
  },
  save: function save(_ref22) {
    var attributes = _ref22.attributes;

    return React.createElement(
      'div',
      null,
      React.createElement(
        'div',
        { className: 'columns' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var linkMosaic_icon = el('svg', { width: 20, height: 20, fill: '#ffffff', stroke: "#000", viewBox: "0 0 24 24" }, el('path', { d: "M0 0h24v24H0z", fill: "none" }), el('path', { d: "M16 21V10h5v10a1 1 0 0 1-1 1h-4zm-2 0H4a1 1 0 0 1-1-1V10h11v11zm7-13H3V4a1 1 0 0 1 1-1h16a1 1 0 0 1 1 1v4z" }));

var linkMosaic_TEMPLATE = [['core/columns', {}, [['core/column', { width: 33.33 }, [['core/image', { url: "https://demo.gutenberghub.com/templates/wp-content/uploads/sites/10/2020/09/d3bymnz0ank-1024x640.jpg" }], ['core/image', { url: "https://demo.gutenberghub.com/templates/wp-content/uploads/sites/10/2020/09/tt-roxwj9na-1024x683.jpg" }]]], ['core/column', { width: 66.66 }, [['core/columns', {}, [['core/column', { width: 33.33 }, [['core/image', { url: "https://demo.gutenberghub.com/templates/wp-content/uploads/sites/10/2020/09/efx1kzhasvo-1024x683.jpg" }]]], ['core/column', { width: 66.66 }, [['core/image', { url: "https://demo.gutenberghub.com/templates/wp-content/uploads/sites/10/2020/09/gwedi4swshq-1024x683.jpg" }]]]]], ['core/columns', {}, [['core/column', { width: 66.66 }, [['core/image', { url: "https://demo.gutenberghub.com/templates/wp-content/uploads/sites/10/2020/09/3q3tsj01nc-1024x683.jpg" }]]], ['core/column', { width: 33.33 }, [['core/button', { customBackgroundColor: "#be1e2d", customTextColor: "#ffffff" }]]]]]]]]]];
var linkMosaicBlock = {
  title: __('Link Mosaic'),
  description: __(''),
  icon: linkMosaic_icon,
  attributes: {},
  edit: function edit(_ref23) {
    var attributes = _ref23.attributes,
        setAttributes = _ref23.setAttributes,
        isSelected = _ref23.isSelected;

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Link Mosaic:'
      ),
      React.createElement(
        'div',
        null,
        React.createElement(InnerBlocks, { template: linkMosaic_TEMPLATE, templateLock: 'all' })
      ),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(PanelBody, { title: __('Block Settings') })
      )
    );
  },
  save: function save(_ref24) {
    var attributes = _ref24.attributes;

    return React.createElement(
      'div',
      null,
      React.createElement(
        'div',
        { className: 'columns' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var featuredText_icon = el('svg', { width: 20, height: 20, viewBox: "0 0 384 512" }, el('path', { d: "M381.5 435.7l-160-384C216.6 39.78 204.9 32.01 192 32.01S167.4 39.78 162.5 51.7l-160 384c-6.797 16.31 .9062 35.05 17.22 41.84c16.38 6.828 35.08-.9219 41.84-17.22l31.8-76.31h197.3l31.8 76.31c5.109 12.28 17.02 19.7 29.55 19.7c4.094 0 8.266-.7969 12.3-2.484C380.6 470.7 388.3 452 381.5 435.7zM119.1 320L192 147.2l72 172.8H119.1z" }));
var featuredText = {
  title: __('Featured Text'),
  description: __(''),
  icon: featuredText_icon,
  attributes: {
    title: {
      type: 'string'
    },

    backgroundflag: {
      type: 'string'
    }
  },

  edit: function edit(_ref25) {
    var attributes = _ref25.attributes,
        setAttributes = _ref25.setAttributes,
        isSelected = _ref25.isSelected;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;

    return React.createElement(
      Fragment,
      null,
      React.createElement(RichText, {
        identifier: 'title',
        tagName: 'h3',
        value: title,
        placeholder: __('Featured Text'),
        onChange: function onChange(title) {
          setAttributes({
            title: title
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref26) {
    var attributes = _ref26.attributes;
    var title = attributes.title,
        backgroundflag = attributes.backgroundflag;


    return React.createElement(
      'div',
      { className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        title && React.createElement('p', { dangerouslySetInnerHTML: { __html: title } })
      )
    );
  }
};

var textimage_TEMPLATE = [['core/columns', {}, [['core/column', {}, [['core/image']]], ['core/column', {}, [['core/heading', { level: 3 }], ['core/paragraph'], ['core/button', {}]]]]]];
var text2image_TEMPLATE = [['core/columns', {}, [['core/column', {}, [['core/image'], ['core/image']]], ['core/column', {}, [['core/heading', { level: 3 }], ['core/paragraph'], ['core/button', {}]]]]]];

var templatekey = 0;
var textImage = {
  title: __('Text + Image'),
  description: __('Side by side text + image'),
  attributes: {
    backgroundflag: {
      type: 'string'
    },
    imagealignment: {
      type: 'string'
    },
    layoutoption: {
      type: 'string'
    }
  },
  edit: function edit(_ref27) {
    var attributes = _ref27.attributes,
        setAttributes = _ref27.setAttributes,
        isSelected = _ref27.isSelected;
    var backgroundflag = attributes.backgroundflag,
        imagealignment = attributes.imagealignment,
        layoutoption = attributes.layoutoption;

    var initialLayout = void 0;


    switch (layoutoption) {
      case "default":
        initialLayout = textimage_TEMPLATE;
        break;
      case "type1":
        initialLayout = text2image_TEMPLATE;
        break;
      default:
        initialLayout = textimage_TEMPLATE;
    };

    var _useState3 = useState(initialLayout),
        _useState4 = _slicedToArray(_useState3, 2),
        textImage_layout = _useState4[0],
        set_textImage_Layout = _useState4[1];

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Text + Image:'
      ),
      React.createElement(InnerBlocks, { template: textImage_layout, templateLock: 'all', key: templatekey }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Image Alignment',
            value: imagealignment,
            description: "Alignment change will reflect in front",
            options: [{ label: 'Left', value: 'left_alignment' }, { label: 'Right', value: 'right_alignment' }],
            onChange: function onChange(imagealignment) {
              setAttributes({
                imagealignment: imagealignment
              });
            }
          }),
          React.createElement(SelectControl, {
            label: 'Layout Option',
            value: layoutoption,
            options: [{ label: 'Text + Image', value: 'default' }, { label: 'Text + 2 Images', value: 'type1' }],
            onChange: function onChange(layoutoption) {
              setAttributes({
                layoutoption: layoutoption
              });
              templatekey = ++templatekey;

              switch (layoutoption) {
                case "default":
                  set_textImage_Layout(textimage_TEMPLATE);
                  break;
                case "type1":
                  set_textImage_Layout(text2image_TEMPLATE);
                  break;
                default:
                  set_textImage_Layout(textimage_TEMPLATE);
              };
            }
          }),
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref28) {
    var attributes = _ref28.attributes;
    var backgroundflag = attributes.backgroundflag,
        imagealignment = attributes.imagealignment,
        layoutoption = attributes.layoutoption;


    return React.createElement(
      'div',
      { className: ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") + ' ' + ((typeof layoutoption === 'undefined' ? 'undefined' : _typeof(layoutoption)) !== undefined ? layoutoption : "textimage") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(
          'div',
          { className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? imagealignment : "left_alignment") },
          React.createElement(InnerBlocks.Content, null)
        )
      )
    );
  }
};

var CTA_TEMPLATE = [['core/button', { align: "center" }]];
var CTA2_TEMPLATE = [['core/heading', { level: 3 }], ['core/paragraph']];

var cta_templatekey = 0;
var cta = {
  title: __('Call to Action'),
  description: __(''),
  attributes: {
    layoutoption: {
      type: 'string'
    }
  },
  edit: function edit(_ref29) {
    var attributes = _ref29.attributes,
        setAttributes = _ref29.setAttributes,
        isSelected = _ref29.isSelected;
    var layoutoption = attributes.layoutoption;

    var initialLayout = void 0;


    switch (layoutoption) {
      case "default":
        initialLayout = CTA_TEMPLATE;
        break;
      case "type1":
        initialLayout = CTA2_TEMPLATE;
        break;
      default:
        initialLayout = CTA_TEMPLATE;
    };

    var _useState5 = useState(initialLayout),
        _useState6 = _slicedToArray(_useState5, 2),
        cta_layout = _useState6[0],
        set_cta_Layout = _useState6[1];

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Call to Action:'
      ),
      React.createElement(InnerBlocks, { template: cta_layout, templateLock: 'all', key: cta_templatekey }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Layout Option',
            value: layoutoption,
            options: [{ label: 'Simple Linked Text', value: 'default' }, { label: 'Title + Body + Link', value: 'type1' }],
            onChange: function onChange(layoutoption) {
              setAttributes({
                layoutoption: layoutoption
              });
              cta_templatekey = ++cta_templatekey;

              switch (layoutoption) {
                case "default":
                  set_cta_Layout(CTA_TEMPLATE);
                  break;
                case "type1":
                  set_cta_Layout(CTA2_TEMPLATE);
                  break;
                default:
                  set_cta_Layout(CTA_TEMPLATE);
              };
            }
          })
        )
      )
    );
  },
  save: function save(_ref30) {
    var attributes = _ref30.attributes;
    var layoutoption = attributes.layoutoption;


    return React.createElement(
      'div',
      { className: '' + ((typeof layoutoption === 'undefined' ? 'undefined' : _typeof(layoutoption)) !== undefined ? layoutoption : "default") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var linkListItem = {
  title: __('Link list Item'),
  description: __(''),
  parent: ['example/linklist-block'],
  attributes: {
    link: {
      type: 'string'
    },
    textcopy: {
      type: 'string'
    }
  },

  edit: function edit(_ref31) {
    var attributes = _ref31.attributes,
        setAttributes = _ref31.setAttributes,
        isSelected = _ref31.isSelected;
    var link = attributes.link,
        textcopy = attributes.textcopy;

    var linkcharsLimit = 34;
    var desccharsLimit = 27;

    var lengthwhithoutTags = function lengthwhithoutTags(str) {
      var tmp = document.createElement("DIV");
      tmp.innerHTML = str;

      return tmp.textContent.length || tmp.innerText.length || 0;
    };

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'div',
        { style: { display: "flex" } },
        React.createElement(RichText, {
          identifier: 'link',
          tagName: 'p',
          value: link,
          description: 'character max of 34',
          placeholder: __('Link Text'),
          onChange: function onChange(link) {
            if (lengthwhithoutTags(link) <= linkcharsLimit) {
              setAttributes({
                link: link
              });
            } else {
              alert("Link text maximum character limit is " + linkcharsLimit);
            }
          },
          onSplit: function onSplit() {
            return null;
          },
          unstableOnSplit: function unstableOnSplit() {
            return null;
          },
          style: { width: "50%", textAlign: "left" }
        }),
        React.createElement(RichText, {
          identifier: 'textcopy',
          tagName: 'p',
          value: textcopy,
          description: 'character max of 27',
          placeholder: __('Description Text'),
          onChange: function onChange(textcopy) {
            if (lengthwhithoutTags(textcopy) <= desccharsLimit) {
              setAttributes({
                textcopy: textcopy
              });
            } else {
              alert("Description text maximum character limit is " + desccharsLimit);
            }
          },
          onSplit: function onSplit() {
            return null;
          },
          unstableOnSplit: function unstableOnSplit() {
            return null;
          },
          style: { width: "50%", textAlign: "right" }
        })
      ),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(PanelBody, { title: __('Block Settings') })
      )
    );
  },
  save: function save(_ref32) {
    var attributes = _ref32.attributes;
    var link = attributes.link,
        textcopy = attributes.textcopy;


    return React.createElement(
      'div',
      null,
      React.createElement(
        'div',
        { className: 'wrapper' },
        link && React.createElement('div', { dangerouslySetInnerHTML: { __html: link } }),
        textcopy && React.createElement('div', { dangerouslySetInnerHTML: { __html: textcopy } })
      )
    );
  }
};

var linkList_ALLOWED_BLOCKS = ['example/linklistitem-block'];

var linkList = {
  title: __('Link List'),
  description: __(''),
  attributes: {
    title: {
      type: 'string'
    }

  },
  edit: function edit(_ref33) {
    var attributes = _ref33.attributes,
        setAttributes = _ref33.setAttributes,
        isSelected = _ref33.isSelected;
    var title = attributes.title;

    return React.createElement(
      Fragment,
      null,
      React.createElement(RichText, {
        identifier: 'title',
        tagName: 'h2',
        value: title,
        placeholder: __('Link List Title'),
        onChange: function onChange(title) {
          setAttributes({
            title: title
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(InnerBlocks, { allowedBlocks: linkList_ALLOWED_BLOCKS })
    );
  },
  save: function save(_ref34) {
    var attributes = _ref34.attributes;
    var title = attributes.title;

    return React.createElement(
      'div',
      null,
      React.createElement(
        'div',
        { className: 'wrapper' },
        title && React.createElement('h2', { dangerouslySetInnerHTML: { __html: title } }),
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var textMosaic_TEMPLATE = [['core/columns', {}, [['core/column', { width: 33 }, [['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut tempus lectus libero, sit amet facilisis leo pharetra ac. " }]]], ['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut tempus lectus libero, sit amet facilisis leo pharetra ac. " }]]]]], ['core/column', { width: 66 }, [['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut tempus lectus libero, sit amet facilisis leo pharetra ac. " }]]], ['core/columns', {}, [['core/column', { width: 66 }, [['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut tempus lectus libero, sit amet facilisis leo pharetra ac. " }]]]]], ['core/column', { width: 33 }, [['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut tempus lectus libero, sit amet facilisis leo pharetra ac. " }]]]]]]]]]]], ['core/columns', {}, [['core/column', { width: 40 }, [['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut tempus lectus libero, sit amet facilisis leo pharetra ac. " }]]]]], ['core/column', { width: 60 }, [['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut tempus lectus libero, sit amet facilisis leo pharetra ac. " }]]]]]]]];
var textMosaic = {
  title: __('Text Mosaic'),
  description: __(''),
  attributes: {
    backgroundflag: {
      type: 'string'
    }
  },

  edit: function edit(_ref35) {
    var attributes = _ref35.attributes,
        setAttributes = _ref35.setAttributes,
        isSelected = _ref35.isSelected;
    var backgroundflag = attributes.backgroundflag;

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Text Mosaic'
      ),
      React.createElement(InnerBlocks, { templateLock: 'all', template: textMosaic_TEMPLATE }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref36) {
    var attributes = _ref36.attributes;
    var backgroundflag = attributes.backgroundflag;

    return React.createElement(
      'div',
      { className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") },
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var fullwidthSlider_ALLOWED_BLOCKS = ['core/image'];

var fullwidthSlider = {
  title: __('Full Width Image Slider'),
  description: __(''),
  attributes: {
    backgroundflag: {
      type: 'string'
    }
  },
  edit: function edit(_ref37) {
    var attributes = _ref37.attributes,
        setAttributes = _ref37.setAttributes,
        isSelected = _ref37.isSelected;
    var backgroundflag = attributes.backgroundflag;

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Full Width Image Slider'
      ),
      React.createElement(InnerBlocks, { allowedBlocks: fullwidthSlider_ALLOWED_BLOCKS }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref38) {
    var attributes = _ref38.attributes;
    var backgroundflag = attributes.backgroundflag;

    return React.createElement(
      'div',
      { 'aria-roledescription': 'carousel', 'aria-label': 'Full Width Image Slider', className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") },
      React.createElement(
        'nav',
        { className: 'slider-navigation' },
        React.createElement(
          'button',
          { className: 'prev', 'aria-controls': 'text-image-slider', 'data-slide': 'prev' },
          ' ',
          React.createElement(
            'span',
            { className: 'visually-hidden-focusable' },
            'Previous Slide'
          ),
          ' '
        ),
        React.createElement(
          'button',
          { className: 'next', 'aria-controls': 'text-image-slider', 'data-slide': 'next' },
          ' ',
          React.createElement(
            'span',
            { className: 'visually-hidden-focusable' },
            'Next Slide'
          ),
          ' '
        )
      ),
      React.createElement(
        'div',
        { className: 'fullwidth-slider-wrapper', 'data-ride': 'carousel', id: 'full-width-slider' },
        React.createElement(InnerBlocks.Content, { 'aria-roledescription': 'Image Slide', role: 'group' })
      )
    );
  }
};

var spaceBlock = {
  title: __('Spacer Block'),
  description: __(''),
  attributes: {
    layoutoption: {
      type: 'string'
    },
    backgroundflag: {
      type: 'string'
    }
  },
  edit: function edit(_ref39) {
    var attributes = _ref39.attributes,
        setAttributes = _ref39.setAttributes,
        isSelected = _ref39.isSelected;
    var layoutoption = attributes.layoutoption,
        backgroundflag = attributes.backgroundflag;


    var initialLayout = void 0;

    if (layoutoption) {
      initialLayout = layoutoption;
    } else {
      initialLayout = "small";
    }

    var _useState7 = useState(initialLayout),
        _useState8 = _slicedToArray(_useState7, 2),
        layout = _useState8[0],
        setLayout = _useState8[1];

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Spacer Block Size: ',
        layout,
        ' '
      ),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(SelectControl, {
            label: 'Size Option',
            value: layoutoption,
            options: [{ label: 'Small', value: 'small' }, { label: 'Medium', value: 'medium' }, { label: 'Large', value: 'large' }],
            onChange: function onChange(layoutoption) {
              setAttributes({
                layoutoption: layoutoption
              });
              setLayout(layoutoption);
            }
          }),
          React.createElement(SelectControl, {
            label: 'Background Color',
            value: backgroundflag,
            options: [{ label: 'White', value: 'white_background' }, { label: 'Grey', value: 'grey_background' }, { label: 'Red', value: 'red_background' }],
            onChange: function onChange(backgroundflag) {
              setAttributes({
                backgroundflag: backgroundflag
              });
            }
          })
        )
      )
    );
  },
  save: function save(_ref40) {
    var attributes = _ref40.attributes;
    var backgroundflag = attributes.backgroundflag,
        layoutoption = attributes.layoutoption;


    return React.createElement(
      'div',
      { className: '' + ((typeof backgroundflag === 'undefined' ? 'undefined' : _typeof(backgroundflag)) !== undefined ? backgroundflag : "white_background") },
      React.createElement('div', { className: '' + ((typeof layoutoption === 'undefined' ? 'undefined' : _typeof(layoutoption)) !== undefined ? layoutoption : "small") })
    );
  }
};

function randomIntFromInterval(min, max) {
  return Math.floor(Math.random() * (max - min + 1) + min);
}
var accordionGroupID = randomIntFromInterval(1, 10);
var accordionID = 0;
var faqItem = {
  title: __('FAQ Accodion Item'),
  description: __(''),
  parent: ['example/faq-block'],
  attributes: {
    title: {
      type: 'string'
    },
    textcopy: {
      type: 'string'
    },
    sectid: {
      type: 'string'
    },
    id: {
      type: 'string'
    }
  },
  edit: function edit(_ref41) {
    var attributes = _ref41.attributes,
        setAttributes = _ref41.setAttributes,
        isSelected = _ref41.isSelected;
    var title = attributes.title,
        textcopy = attributes.textcopy;


    accordionID = randomIntFromInterval(1, 100);

    return React.createElement(
      Fragment,
      null,
      React.createElement(RichText, {
        identifier: 'title',
        tagName: 'h3',
        value: title,
        placeholder: __('FAQ Accordion Title'),
        onChange: function onChange(title) {
          setAttributes({
            title: title,
            id: 'accordion' + accordionGroupID + accordionID + 'id',
            sectid: 'sect' + accordionGroupID + accordionID
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(RichText, {
        identifier: 'textcopy',
        tagName: 'p',
        value: textcopy,
        placeholder: __('FAQ Accordion Body Copy'),
        onChange: function onChange(textcopy) {
          setAttributes({
            textcopy: textcopy
          });
        },
        onSplit: function onSplit() {
          return null;
        },
        unstableOnSplit: function unstableOnSplit() {
          return null;
        }
      }),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(PanelBody, { title: __('Block Settings') })
      )
    );
  },
  save: function save(_ref42) {
    var attributes = _ref42.attributes;
    var title = attributes.title,
        textcopy = attributes.textcopy,
        id = attributes.id,
        sectid = attributes.sectid;

    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'div',
        { 'class': 'faqitem' },
        React.createElement(
          'div',
          { 'class': 'faq-title h3' },
          React.createElement(
            'button',
            { type: 'button', 'aria-expanded': 'false', 'class': 'accordion-trigger', 'aria-controls': sectid, id: id },
            React.createElement(
              'span',
              { 'class': 'accordion-title' },
              title && React.createElement('span', { dangerouslySetInnerHTML: { __html: title } }),
              React.createElement('span', { 'class': 'accordion-icon' })
            )
          )
        ),
        React.createElement(
          'div',
          { id: sectid, role: 'region', 'aria-labelledby': id, 'class': 'accordion-panel', hidden: true },
          textcopy && React.createElement('div', { dangerouslySetInnerHTML: { __html: textcopy } })
        )
      )
    );
  }
};

var faq_ALLOWED_BLOCKS = ['example/faqitem-block'];
var faqBlock = {
  title: __('FAQ Accordion'),
  description: __(''),
  attributes: {
    groupid: {
      type: 'string',
      value: accordionGroupID
    }
  },
  edit: function edit(_ref43) {
    var attributes = _ref43.attributes,
        setAttributes = _ref43.setAttributes,
        isSelected = _ref43.isSelected;


    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'FAQ Accordion'
      ),
      React.createElement(InnerBlocks, { allowedBlocks: faq_ALLOWED_BLOCKS })
    );
  },
  save: function save(_ref44) {
    var attributes = _ref44.attributes;
    var groupid = attributes.groupid;


    return React.createElement(
      'div',
      null,
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(
          'div',
          { id: groupid, 'class': 'accordion' },
          React.createElement(InnerBlocks.Content, null)
        )
      )
    );
  }
};

var category = {
  slug: 'example',
  title: __('Advanced Gutenberg Blocks')
};

var audio_TEMPLATE = [['core/columns', {}, [['core/column', {}, [['core/group', {}, [['drupalmedia/drupal-media-entity']]]]], ['core/column', {}, [['core/group', {}, [['core/heading', { level: 3, placeholder: "Title" }], ['core/paragraph', { placeholder: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. " }]]]]]]]];
var audioBlock = {
  title: __('Custom Audio Block'),
  description: __(''),
  attributes: {},

  edit: function edit(_ref45) {
    var attributes = _ref45.attributes,
        setAttributes = _ref45.setAttributes,
        isSelected = _ref45.isSelected;


    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'h2',
        null,
        'Audio Block'
      ),
      React.createElement(InnerBlocks, { templateLock: 'all', template: audio_TEMPLATE }),
      React.createElement(InspectorControls, null)
    );
  },
  save: function save(_ref46) {
    var attributes = _ref46.attributes;


    return React.createElement(
      'div',
      null,
      React.createElement(
        'div',
        { className: 'wrapper' },
        React.createElement(InnerBlocks.Content, null)
      )
    );
  }
};

var currentCategories = select('core/blocks').getCategories().filter(function (item) {
  return item.slug !== category.slug;
});
dispatch('core/blocks').setCategories([category].concat(_toConsumableArray(currentCategories)));

registerBlockType(category.slug + '/sectionbreak-block', _extends({ category: category.slug }, sectionBreakH2));
registerBlockType(category.slug + '/customheading-block', _extends({ category: category.slug }, customHeading));
registerBlockType(category.slug + '/highlightedtext-block', _extends({ category: category.slug }, highlightedText));
registerBlockType(category.slug + '/imagegrid-block', _extends({ category: category.slug }, imageGrid));
registerBlockType(category.slug + '/customtext-block', _extends({ category: category.slug }, CustomTextBlock));
registerBlockType(category.slug + '/textimageslide-block', _extends({ category: category.slug }, TextImageSlide));
registerBlockType(category.slug + '/textimageslider-block', _extends({ category: category.slug }, TextImageSlider));
registerBlockType(category.slug + '/customfeaturedmedia-block', _extends({ category: category.slug }, CustomFeaturedMediaBlock));
registerBlockType(category.slug + '/customimagemosaic-block', _extends({ category: category.slug }, imageMosaicBlock));
registerBlockType(category.slug + '/teammember-block', _extends({ category: category.slug }, teamMemberBlock));
registerBlockType(category.slug + '/mediarepeater-block', _extends({ category: category.slug }, mediaRepeaterBlock));
registerBlockType(category.slug + '/linkmosaic-block', _extends({ category: category.slug }, linkMosaicBlock));
registerBlockType(category.slug + '/featuredtext-block', _extends({ category: category.slug }, featuredText));
registerBlockType(category.slug + '/textimage-block', _extends({ category: category.slug }, textImage));
registerBlockType(category.slug + '/cta-block', _extends({ category: category.slug }, cta));
registerBlockType(category.slug + '/linklistitem-block', _extends({ category: category.slug }, linkListItem));
registerBlockType(category.slug + '/linklist-block', _extends({ category: category.slug }, linkList));
registerBlockType(category.slug + '/textmosaic-block', _extends({ category: category.slug }, textMosaic));
registerBlockType(category.slug + '/fullwidthslider-block', _extends({ category: category.slug }, fullwidthSlider));
registerBlockType(category.slug + '/spacer-block', _extends({ category: category.slug }, spaceBlock));
registerBlockType(category.slug + '/faqitem-block', _extends({ category: category.slug }, faqItem));
registerBlockType(category.slug + '/faq-block', _extends({ category: category.slug }, faqBlock));
registerBlockType(category.slug + '/audio-block', _extends({ category: category.slug }, audioBlock));