This is a small service module that may be used by other modules to
produce a string that may be inserted into a project's `hook_help` to
hint about the documentation that exists.

It has no administrative UI and will not do anything by itself.

I created this module because I found that I used the same pattern
inside `hook_help` on almost *every* Drupal module I maintain.
Replicated patterns consumes memory, and are harder to maintain.
Instead, to make use of this pattern, call the helper function this
module provides.

## Recommended modules

* [Advanced Help][1]:  
  When this module is enabled, help files created with its framework
  will become available, or `README.md` or `README.txt` will be
  available in the sites's adminsitrative UI.

## Installation

1. Install as you would normally install a contributed drupal
   module. See: [Installing modules][3] for further information.

2. Edit your own module's `hook_help` to make use of the result of
   calling `produceHint()`.  For details, see the section headed
   “Service” section below.

## Configuration

This module has no administrative or other UI.  It will usually only
be enabled if listed as required by some other module.

## Service

If you want to make use of this module, first make it required in your
module's `.info.yml`-file.  You do that with the following:

    dependencies:
      - advanced_help_hint:advanced_help_hint

The module provides this service `advanced_help_hint.gethint` with a
class named `Hint`.

The public function `produceHint` generates a hint string that may
point to online documentation, the project's `README.md` or
`README.txt`, or help texts provided by **Advanced help**:

    public function produceHint($project, $doclink = NULL, $repo = FALSE)

The major features of this function are:

1. If **Advanced help** is not enabled, and you've indicated that
   there are helps file in your repo, it will suggest that it is
   enabled.

2. If **Advanced help** is enabled, it will generate a link to
   whatever help it makes available.

3. If you tell it that online documentation for your module exists, it
   will generate a link to that as well.

The hint generated is suitable for use in the project's `hook_help`.
See below for a complete example.


### Function parameters

**$project**: String.  The short name of your module or theme.

**$doclink**: String. An URL to online documentation, for example
community documentation about your project on Drupal.org.

**$repo**: Boolean. Set this TRUE if your project makes use of the
[**Advanced help**][1] framework to have have online help, or includes
a `README.md` or `README.txt` help file in the repo.

### Return value

A string with the generated hint text.

### Example

Provided your module is named “mymodule”, assuming that online
documentation exists on the following URL
“https://www.drupal.org/docs/8/modules/mymodule”, and that in a file
named “README.md”, “README.txt” or a subdirectory “help” included in
the repo, here are an example of how to make a rather minimal
`hook_help` by injecting the service `advanced_help_hint.gethint`:

    function mymodule_help($route_name, RouteMatchInterface $route_match) {
      switch ($route_name) {
        case 'help.page.mymodule':
          $hint_service = \Drupal::service('advanced_help_hint.gethint');
          return '<p>' . t('Some short description the module.') . '</p>' .
            '<p>' .
            $hint_service->produceHint('mymodule',
              'https://www.drupal.org/docs/8/modules/mymodule', TRUE) .
            '</p>';
      }
    }


      


## Maintainers

Project is maintained by [gisle][4] (Gisle Hannemyr).

Any help with development (patches, reviews, comments) are welcome.

Development has been sponsored by [Hannemyr Nye Medier AS][5].

[1]: https://www.drupal.org/project/advanced_help
[3]: https://www.drupal.org/node/1897420
[4]: https://www.drupal.org/u/gisle
[5]: http://hannemyr.com/hnm/