<?php

namespace Drupal\advanced_help_hint;

use Drupal\Core\Link;
use Drupal\Core\Url;
use Drupal\Component\Render\FormattableMarkup;

/**
 * The Hint class produces a hint string for hook_help().
 */
class Hint {

  /**
   * Assemples and returns the hint.
   */
  public function produceHint($project, $doclink = NULL, $repo = FALSE) {

    $output = '';
    if ($doclink) {
      $options = ['attributes' => ['title' => t('Link to documentation of the project online.')]];
      $link = Link::fromTextAndUrl(t('online documentation'), Url::fromUri($doclink, $options))->toString();
      $ss = new FormattableMarkup(
        t('Please see the @url.'), ['@url' => $link]
      );
      $output .= $ss;
    }
    if (\Drupal::moduleHandler()->moduleExists('advanced_help')) {
      $plugin_manager = \Drupal::service('plugin.manager.advanced_help');
      $topics = $plugin_manager->getTopics();
      if (!empty($output)) {
        $output = $output . ' ';
      }
      if (!$repo) {
        $output .=
          t("No additional help available for “!project”.",
            array(
              '!project' => $project,
            )
          );
        // Nothing more to do.
        return $output;
      }
      if (!isset($topics[$project])) {
        $output .=
          t("Expected to find some help for project “@project” in the project's help-directory, but could not locate any.",
            array(
              '@project' => $project,
            )
          );
        // Nothing more to do.
        return $output;
      }

      $file = key($topics[$project]);
      $ext = pathinfo($file, PATHINFO_EXTENSION);
      $helpPath = '/admin/help/ah/' . $project;
      if (empty($ext))  {
        $options = ['attributes' => ['title' => t('Link to advanced help')]];
        $link = Link::fromTextAndUrl(
          t('advanced help framework'),
          Url::fromUri('base:' . $helpPath, $options)
        )->toString();
        $ss = new FormattableMarkup(
          t('Additional help is provided by the @help.'), ['@help' => $link]
        );
        $output .= $ss;
      }
      else {
        $options = ['attributes' => ['title' => t('Link to included documentation.')]];
        $link = Link::fromTextAndUrl(
          t('README'),
          Url::fromUri('base:' . $helpPath, $options)
        )->toString();
        $ss = new FormattableMarkup(
          t("Additional help is available in the project's “@readme” file."), ['@readme' => $link]
        );
        $output .= $ss;
      }

    } elseif ($repo)  {
      if (!empty($output)) {
        $output = $output . ' ';
      }
      // Since advanced_help is not enabled we can't check to make sure help is available.
      $options = ['attributes' => ['title' => t('Link to the Advanced Help project.')]];
      $link = Link::fromTextAndUrl(t('Advanced Help'), Url::fromUri('https://www.drupal.org/project/advanced_help', $options))->toString();
      $ss = new FormattableMarkup(
        t('If you install the @advhelp module, additional help may be available.'), ['@advhelp' => $link]
      );
      $output .= $ss;
    }
    return $output;
  }


}
