<?php
/*
 * Menu handlers and functions for work with unused images. E.g. mass delete of them. etc.
 * (c) Ilya V. Azarov, 2011. Advanced image gallery module
 */

DEFINE('ADVIMAGE_USER_FREE_PHOTOS_PER_PAGE', 20);
/*
 * Returns form for work with free not used images
 * Mainly to delete them
 */
function advimage_user_free_images($form_state, $account) {
  $mpath = drupal_get_path('module', 'advimage');
  drupal_add_css($mpath .'/css/advimage.css', 'module');
  if(
    isset($form_state['advimage_user_free_images_delete'] )
  ) {
    return advimage_user_free_images_delete_confirm($form_state, $account);
  }
  return advimage_user_free_images_delete($form_state, $account);
}

/*
 * Confirmation form to delete nodes
 */

function advimage_user_free_images_delete_confirm($form_state, $account) {
  $form = array();
  $form['nodes'] = array('#prefix' => '<ul>', '#suffix' => '</ul>', '#tree' => TRUE);
  foreach($form_state['advimage_user_free_images_delete']  as $value) {
    $nid = $value['nid'];
    $form['nodes'][$nid] = array(
      '#type' => 'hidden',
      '#value' => $nid,
      '#prefix' => '<li>',
      '#suffix' => check_plain($value['title'] ) ."</li>\n",
    );
  }
  $form['operation'] = array('#type' => 'hidden', '#value' => 'delete');
  $form['#redirect'] = 'user/' . $account->uid . '/advimage/freeimages';
  $form['uid'] = array(
    '#type' => 'hidden',
    '#default_value' => $account->uid,
    '#value' => $account->uid,
  );
  $form['#submit'][] = 'advimage_user_free_images_delete_confirm_submit';
  return confirm_form($form,
                      t('Are you sure you want to delete these items?'),
                      'user/' . $account->uid . '/advimage/freeimages', t('This action cannot be undone.'),
                      t('Delete all'), t('Cancel'));
}

function advimage_user_free_images_delete_confirm_submit($form, $form_values) {
  $uid = $form['uid'] ['#value'];
  if (count($form_values['values'] ['nodes'] ) ) {
    foreach ( $form_values['values'] ['nodes'] as $nid) {
      if(
        is_numeric($nid) 
        && ($node = node_load(array('nid' => $nid) ) ) 
        && ($uid == $node->uid)
      ) {
        node_delete($nid);
      }
    }
  }
  drupal_set_message(t('Images were successfully deleted') );
}

/*
 * Form to delete wrong nodes
 */
function advimage_user_free_images_delete($form_state, $account) {
  $mpath = drupal_get_path('module', 'advimage');
  drupal_add_css($mpath .'/css/advimage.css', 'module');
  drupal_add_js($mpath . '/js/advimage_freeimages.js', 'module', 'footer');
  $result =  pager_query('SELECT 
DISTINCT(n.nid) AS nid, n.created, n.vid, n.title
FROM {node} n LEFT JOIN {content_field_advgallery} ag ON n.nid=ag.field_advgallery_nid
LEFT JOIN {node} n1 ON n1.vid=ag.vid and n1.nid=ag.nid
WHERE n.uid=%d AND n.type=\'advimage\' AND (n1.nid IS NULL)
ORDER BY n.created DESC', ADVIMAGE_USER_FREE_PHOTOS_PER_PAGE, 0, NULL, $account->uid);
  $nodes = array();
  while ( ($row = db_fetch_array($result) ) && ($node = node_load(array('nid' => $row['nid'] ) ) ) ) {
    if (
      @is_array($node->field_advimage) 
      && is_array($node->field_advimage[0] ) 
      && !empty($node->field_advimage[0]['filepath'] ) 
    ) {
      $row['field_advimage'] = $node->field_advimage;
    } else {
      // nothing to show
      $row['field_advimage'] = null;
    }
    $nodes []= $row;
  }
  if (count($nodes) ) {
  } else {
    $form = array(
      'nothingfound' => array(
        '#type' => 'markup',
        '#value' => '<div class="advimage-user-free-images-nothing">' 
          . t('You have no unused images at the moment')
          . '</div>',
      ),
    );
    return $form;
  }
  $form = array();
  $form['#redirect'] = 'user/' . $account->uid . '/advimage/freeimages';
  $form['uid'] = array(
    '#type' => 'hidden',
    '#default_value' => $account->uid,
    '#value' => $account->uid,
  );
  $form['table'] =  array(
    '#theme' => 'advimage_user_free_images_delete_table',
    '#tree' => TRUE,
  );
  $form['table'] ['allcheckbox'] = array(
    '#type' => 'checkbox',
    '#default_value' => FALSE,
  );
  foreach ( $nodes as $value) {
    $key = $value['nid'];
    $form['table'] [$key] = array(
      'nid-' . $key => array(
        '#type' => 'checkbox',
        '#default_value' => FALSE,
      ),
      'nodeimage-' . $key => array(
        '#type' => 'markup',
        '#value' => theme('advimage_user_free_images_image', $value),
      ),
      'nodetitle-' . $key => array(
        '#type' => 'markup',
        '#value' => l(
          $value['title'], 
          'node/' . $value['nid'],
          array('attributes' => array('class' => 'advimage-user-free-images-link') )
        ),
      ),
      'title-' . $key => array(
        '#type' => 'hidden',
        '#value' => $value['title'],
      ),
    );
  }
  $form['delete'] = array(
    '#type' => 'submit',
    '#value' => t('Delete selected images'),
    '#submit' => array('advimage_user_free_images_delete_submit'),
  );
  $form['pager'] = array(
    '#type' => 'markup',
    '#value' => theme('pager'),
  );
  return $form;
}
function advimage_user_free_images_delete_submit($form, &$form_state) {
  if(
    is_array($form_state['values'] ['table'] ) 
    && (count($form_state['values'] ['table'] ) >= 0)
  ) {
    $nodes = array();
    foreach($form['table'] as $key => $item) {
      if(
        is_numeric($key)
        && $form_state['values'] ['table'][$key] ['nid-' . $key]
        && ($node = node_load(array('nid' => $key) ) ) 
        && ($node->uid == $form['uid']['#value'] )
      ) {
        $nodes []= array(
          'nid' => $node->nid,
          'title' => $node->title,
        );
      }
    }
    if(count($nodes) ) {
      $form_state['advimage_user_free_images_delete'] = $nodes;
      $form_state['rebuild'] = TRUE;
    }
  }
}

/*
 * Draws image for the given node
 */
function theme_advimage_user_free_images_image($node) {
  $out = '';
  if ($node['field_advimage'] ) {
    $url = imagecache_create_url('advimage_mini', $node['field_advimage'][0]['filepath'] );
    $out .= l(
      '<img title="' . check_plain($node['title'] ) 
        . '" alt="' . check_plain($node['title'] ) 
        . '" src="' . check_plain($url) . '" />', 
      'node/' . $node['nid'], 
      array(
        'html' => TRUE,  
        'attributes' => array('class' => 'advimage-user-free-images-image')
      )
    );
  } else {
    $out .= '<span class="advimage-user-free-images-noimage">' . t('No image was uploaded') . '</span>';
  }
  return $out;
}

/*
 * Draws table for delete form
 */
function theme_advimage_user_free_images_delete_table($form) {
  $header = array(drupal_render($form['allcheckbox'] ), t('Image'), t('Title') );
  $rows = array();
  $odd = false;
  foreach (element_children($form) as $key) {
    if(is_numeric($key) ) {
      $odd = !$odd;
      $rows []= array(
        'data' => array(
          drupal_render($form[$key]['nid-' . $key] ) . drupal_render($form[$key]['title-' . $key] ),
          array(
            'data' => drupal_render($form[$key]['nodeimage-' . $key] ), 
            'class' => 'advimage-user-free-images-image',
          ),
          array(
            'data' => drupal_render($form[$key]['nodetitle-' . $key] ),
            'class' => 'advimage-user-free-images-title',
          ),
        ), 
        'class' => ''
      );
    }
  }
  return theme('table', $header, $rows, array('id' => 'advimage-user-free-images-delete-table') );
}
