<?php
/*
 *  Advimage nodereference widget module
 * (c) Ilya V. Azarov, brainstorm@brainstorm.name, 2011
 * Intended to add images to arctiles and give variants of code to insert them there.
 * Module administration pages
 */
 
/*
 * Page with list of formats and form to reorder weights of formats
 */
function advimage_ref_admin_formats_list() {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  $formats = _advimage_ref_get_formats(TRUE);
  drupal_set_title('Advimage referernce module  formats settings');
  return drupal_get_form('advimage_ref_formats_reorder_form', $formats);
}
/* 
 * Form to reorder formats
 */
function advimage_ref_formats_reorder_form(&$form_state, $formats) {
  $form = array();
  $form['#redirect'] = array('admin/settings/advimage_ref');
  $form['table'] = array(
    '#theme' => 'advimage_ref_format_weight_table',
    '#tree' => TRUE,
  );
  foreach ($formats as $row) {
    $fname = $row['fname'];
    $actions = l('Edit', 'admin/settings/advimage_ref/edit/' . $fname);
    if ( ($fname != 'original') && ($fname != 'preview') ) {
      $actions .= ' | ' . l('Delete', 'admin/settings/advimage_ref/delete/' . $fname);
    }
    $form['table'][$fname] = array(
      'fname-' . $fname => array(
        '#type' => 'hidden',
        '#value' => $fname,
      ),
      'markfname-' . $fname => array(
        '#type' => 'markup',
        '#value' => $fname,
      ),
      'markdescr-' . $fname => array(
        '#type' => 'markup',
        '#value' => check_plain($row['descr'] ),
      ),
      'actions-' . $fname => array(
        '#type' => 'markup',
        '#value' => $actions,
      ),
      'weight-' . $fname => array(
        '#type' => 'weight',
        '#default_value' => $row['weight'],
      ),
    );
  }
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Save weights'),
  );
  return $form;
}
/*
 * Submit new order of formats to the database
 */
function advimage_ref_formats_reorder_form_submit($form, &$form_state) {
  $formats = _advimage_ref_get_formats(TRUE);
  foreach($formats as $row) {
    if(isset($form_state['values'] ['table'] [$row['fname'] ] ['weight-' . $row['fname'] ] ) ) {
      $weight  = 0 + $form_state['values'] ['table'] [$row['fname'] ] ['weight-' . $row['fname'] ];
      db_query(
        'UPDATE {advimage_ref} SET weight=%d WHERE fname=\'%s\'',
        $weight,
        $row['fname']
      );
    }
  }
  // refresh caches again
  $formats = _advimage_ref_get_formats(TRUE);
  drupal_set_message(t('Formats were successfully reordered') );
}
/*
 * Theme table for above form
 */
function theme_advimage_ref_format_weight_table($form) {
  drupal_add_tabledrag('advimage-ref-format-weight-table', 'order', 'sibling', 'weight');
  $header = array( t('Name'), t('Description'), t('Weight'), t('Operations') );
  $rows = array();
  $destination = drupal_get_destination();
  foreach (element_children($form) as $fname) {
    $form[$fname]['weight-' . $fname]['#attributes']['class'] = 'weight';
    $data = array(
      drupal_render($form[$fname]['markfname-' . $fname] ),
      drupal_render($form[$fname]['markdescr-' . $fname] ),
      drupal_render($form[$fname]['weight-' . $fname] ), 
      drupal_render($form[$fname]['actions-' . $fname] ),
    );
    $rows []= array('data' => $data, 'class' => 'draggable');
  }
  return theme('table', $header, $rows, array('id' => 'advimage-ref-format-weight-table') );
}
/*
 * Page intended to add new format for image displaying
 */
function advimage_ref_admin_formats_add() {
  return drupal_get_form('advimage_ref_admin_formats_add_form');
}
/*
 * Form to add new format
 */
function advimage_ref_admin_formats_add_form(&$form_state) {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  $formats = _advimage_ref_get_formats();
  $fnames = array();
  $fnames ['-'] = '--------------';
  foreach($formats  as $row) {
    $fnames[$row['fname'] ] = $row['fname'] . ' : ' . $row['descr'];
  }
  $form = array(
    'fname' => array(
      '#type' => 'textfield',
      '#title' => t('Name'),
      '#description' => t('Machine readable name of format(a-z0-9_)'),
    ),
    'descr' => array(
      '#type' => 'textarea',
      '#title' => t('Description'),
      '#description' => t('Machine readable name of format(a-z0-9_)'),
    ),
    'base_fname' => array(
      '#type' => 'select',
      '#multiple' => FALSE,
      '#title' => t('Select format to base new on'),
      '#description' => t('Select existing format as a base template'),
      '#options' => $fnames,
    ),
    'submit' => array(
      '#type' => 'submit',
      '#title' => t('Create'),
      '#value' => t('Create'),
    ),
    '#redirect' => array('admin/settings/advimage_ref'),
  );
  return $form;
}
/*
 * Validate format name
 */
function advimage_ref_admin_formats_add_form_validate($form, &$form_state) {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  if (empty($form_state['values']['fname'] ) ) {
    form_set_error('fname', t('Name of format cannot be empty!') );
    return;
  }
  $matches = array();
  if(!preg_match('#^([a-z0-9_]+)$#i',  $form_state['values']['fname'], $matches) ) {
    form_set_error('fname', t('Wrong format name') );
    return;
  }
  if (!preg_match('#^([a-z])#i', $form_state['values']['fname'], $matches) ) {
    form_set_error('fname', t('Format name must begin from letter') );
    return;
  }
  if($fmt = _advimage_ref_get_format($form_state['values']['fname'] ) ) {
    form_set_error('fname', t('This format name already exists') );
    return;
  }
}
/*
 * Store to the database format based on original and redirect to edit page
 */
function advimage_ref_admin_formats_add_form_submit($form, &$form_state) {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  $base = NULL;
  $matches = array();
  if ( preg_match('#^([a-z0-9_]+)$#i',  $form_state['values']['base_fname'], $matches) ) { 
    $base = _advimage_ref_get_format($form_state['values']['base_fname'] );
  }
  $formats = _advimage_ref_get_formats();
  $weight = 0;
  if (count($formats) ) {
    $weight = $formats[count($formats) - 1] ['weight'] + 1;
  }
  $newfmt = array(
    'fname' => $form_state['values']['fname'], 
    'weight' => $weight,
    'descr' => $form_state['values']['descr'],
    'templatetext' => '',
    'default_options' => '',
  );
  if($base) {
    $newfmt['templatetext'] = $base['templatetext'];
    $newfmt['default_options'] = $base['default_options'];
  }
  db_query(
    'INSERT INTO {advimage_ref}(fname, weight, descr, templatetext, default_options) VALUES(\'%s\', %d, \'%s\', \'%s\', \'%s\')',
    $newfmt['fname'], 
    $newfmt['weight'], 
    $newfmt['descr'], 
    $newfmt['templatetext'], 
    $newfmt['default_options']
  );
  // flush cache
  _advimage_ref_get_formats(TRUE);
  drupal_set_message(t('New format was created') );
}
/*
 * Delete existing format
 */
function advimage_ref_admin_formats_delete($fname = NULL) {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  if ( ($fname == 'original' ) || ($fname == 'preview' ) ) {
    drupal_set_message(t('\'original\' and \'preview\' formats are system default formats and cannot be removed'), 'warning');
    drupal_goto('admin/settings/advimage_ref');
  }
  $matches = array();
  if (
    preg_match('#^([a-z0-9_]+)$#i',  $fname, $matches) 
    && preg_match('#^([a-z])#i', $fname, $matches) 
    && ($format = _advimage_ref_get_format($fname, TRUE) )
  ) {
    drupal_set_title(t('Delete format') );
    return drupal_get_form('advimage_ref_admin_formats_delete_form', $format);
  } else {
    drupal_not_found();
  }
}
/*
 * Confirmation form while deleting format
 */
function advimage_ref_admin_formats_delete_form(&$form_state, $format) {
  $form = array(
    'fname' => array(
      '#type' => 'hidden',
      '#value' => $format['fname'],
    ),
    '#redirect' => array('admin/settings/advimage_ref'),
  );
  return confirm_form(
    $form,
    t('Delete format \'%format\'', array('%format' => $format['fname'] ) ),
    'admin/settings/advimage_ref',
    t('Press delete button if you really want delete this formatting'),
    t('Delete'),
    t('Cancel')
  );
}

/*
 * Submit delete format
 */
function advimage_ref_admin_formats_delete_form_submit($form, &$form_state) {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  $fname = $form['fname']['#value'];
  $matches = array();
  if (
    preg_match('#^([a-z0-9_]+)$#i',  $fname, $matches) 
    && preg_match('#^([a-z])#i', $fname, $matches) 
    && ($fname != 'original' )
    && ($fname != 'preview' )
    && ($format =  _advimage_ref_get_format($fname) )
  ) {
    db_query('DELETE FROM {advimage_ref} WHERE fname=\'%s\'', $fname);
    _advimage_ref_get_formats(TRUE);
    drupal_set_message(t('Format \'%fname\' was successfully deleted', array('%fname' => $fname) ) );
    return;
  }
}
/*
 * Edit format settings page
 */
function advimage_ref_admin_formats_edit($fname = NULL) {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  $matches = array();
  if (
    preg_match('#^([a-z0-9_]+)$#i',  $fname, $matches) 
    && preg_match('#^([a-z])#i', $fname, $matches) 
    && ($format = _advimage_ref_get_format($fname, TRUE) ) 
  ) {
    drupal_set_title(t('Edit format \'%fname\'', array('%fname' => $fname) ) );
    return drupal_get_form('advimage_ref_admin_formats_edit_form', $format);
  } else {
    drupal_not_found();
  }
}
function advimage_ref_admin_formats_edit_form(&$form_state, $format) {
 return array(
    '#redirect' => array('admin/settings/advimage_ref'),
    'fname' => array(
      '#type' => 'hidden',
      '#value' => $format['fname'],
    ),
    'fname-mark' => array(
      '#type' => 'markup',
      '#value' => t('Format name: ') . '<strong>' . $format['fname'] . '</strong>',
    ),
    'descr' => array(
      '#type' => 'textarea',
      '#title' => t('Description'),
      '#description' => t('Enter shot description of what that formatting type does'),
      '#default_value' => $format['descr'],
    ),
    'templatetext' => array(
      '#type' => 'textarea',
      '#title' => t('HTML Template'),
      '#description' => t('Enter template here. Another way is customize that via theme functions'),
      '#default_value' => $format['templatetext'],
      '#suffix' => theme('advimage_ref_tokens_description', _advimage_ref_get_tokens_descriptions_array() ),
    ),
    'default_options' => array(
      '#type' => 'select',
      '#title' => t('Default variants of image placement  the document body'),
      '#description' => t('Select default alignment for image'),
      '#default_value' => $format['default_options'],
      '#options' => array(
        'floatleft' => t('Floating on the left from the text'),
        'floatright' => t('Floating on the right from the text'),
        'floatnone' => t('No alignment defined'),
      ),
    ),
    'submit' => array(
      '#type' => 'submit',
      '#title' => t('Save'),
      '#value' => t('Save'),
    ),
  );
}
function advimage_ref_admin_formats_edit_form_submit($form, &$form_state) {
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  $fname = $form['fname']['#value'];
  $matches = array();
  if (
    preg_match('#^([a-z0-9_]+)$#i',  $fname, $matches) 
    && preg_match('#^([a-z])#i', $fname, $matches) 
    && ($format =  _advimage_ref_get_format($fname) )
  ) {
    $options = array(
      'floatleft', 'floatright', 'newlineleft', 'newlineright', 'newlinecenter'
    );
    // morons protection
    $default_options = $form_state['values']['default_options'];
    if (!in_array($default_options, $options) ) {
      $default_options = 'floatleft';
    }
    db_query('UPDATE {advimage_ref} SET descr=\'%s\', templatetext=\'%s\', default_options=\'%s\' WHERE fname=\'%s\'', 
      $form_state['values']['descr'],
      $form_state['values']['templatetext'],
      $default_options,
      $fname
    );
    _advimage_ref_get_formats(TRUE);
    cache_clear_all('cache_filter');
    drupal_set_message(t('Format \'%fname\' was successfully saved', array('%fname' => $fname) ) );
  }
}
function theme_advimage_ref_tokens_description($tokenslist) {
  $out = '<ul>';
  foreach($tokenslist as $token => $description) {
    $out .= '<li><strong>' 
      . check_plain($token) 
      . '</strong>: ' 
      . check_plain($description) . '</li>';
  }
  $out .= '</ul>';
  $out .= '<em>' 
    . t('All tokens are escaped via check_plain() routine. To use raw values - just use -raw suffixes. E.g. [inodeurl-raw], [imageurl_presetname-raw]') 
    . '</em>';
  return $out;
}
