/*
 *  Advimage nodereference widget module
 * (c) Ilya V. Azarov, brainstorm@brainstorm.name, 2011
 * Module JavaScript file
 */
(function($) { // jQuery wrapper to prevent conflicts
  Drupal = Drupal || {};
  Drupal.advimage_ref = Drupal.advimage_ref || {};
  Drupal.advimage_ref.itemlist_id = undefined;
  Drupal.advimage_ref.callShowMoreByButton = false;
  Drupal.advimage_ref.moreavailable = 0;
  // current page in the selection pane
  Drupal.advimage_ref.selection_page = 0;
  // cache of loaded nodes we have info for
  Drupal.advimage_ref.loadedNodesCache = Drupal.advimage_ref.loadedNodesCache || {};
  Drupal.advimage_ref.codeToInsert = undefined;
  /*
   * 
   * Mousewheel for 1.2-1.3 only!!!!
   **/
  if($.fn.mousewheel == undefined) {
    var types = ['DOMMouseScroll', 'mousewheel'];

    $.event.special.mousewheel = {
      setup: function() {
        if ( this.addEventListener )
          for ( var i=types.length; i; )
            this.addEventListener( types[--i], handler, false );
        else
          this.onmousewheel = handler;
      },
      
      teardown: function() {
        if ( this.removeEventListener )
          for ( var i=types.length; i; )
            this.removeEventListener( types[--i], handler, false );
        else
          this.onmousewheel = null;
      }
    };

    $.fn.extend({
      mousewheel: function(fn) {
        return fn ? this.bind("mousewheel", fn) : this.trigger("mousewheel");
      },
      
      unmousewheel: function(fn) {
        return this.unbind("mousewheel", fn);
      }
    });

    function handler(event) {
      var args = [].slice.call( arguments, 1 ), delta = 0, returnValue = true;
      
      event = $.event.fix(event || window.event);
      event.type = "mousewheel";
      
      if ( event.wheelDelta ) delta = event.wheelDelta/120;
      if ( event.detail     ) delta = -event.detail/3;
      
      // Add events and delta to the front of the arguments
      args.unshift(event, delta);

      return $.event.handle.apply(this, args);
    }
  }
  
  /*
   * Mouse wheel worker
   */
  Drupal.advimage_ref.mouseWheel = function (event, delta) {
    var wdth = $('#advimage-ref-js-widget-selection table.table.advimage-ref-selection').attr('clientWidth');
    var clnth = $('#advimage-ref-js-widget-selection').attr('clientWidth');
    var scr = $('#advimage-ref-js-widget-selection').attr('scrollLeft');
    var ch = Math.floor($('#advimage-ref-js-widget-selection').attr('clientWidth') / 5);
    var dr = (delta < 0) ? 1 : (-1);
    var newpos = scr + dr * ch;
    if(newpos >= wdth) newpos = wdth;
    if(newpos < 0) newpos = 0;
    $('div#advimage-ref-js-widget-selection').animate({scrollLeft: newpos}, 50);
    //$('#advimage-ref-js-widget-selection').attr('scrollLeft', newpos);
    return false;
  }
  // init with initial system checks
  Drupal.advimage_ref.showButtonInit_init = function(){
    Drupal.advimage_ref.itemlist_id = Drupal.settings.advimage_ref.fieldname.replace('_', '-') + '-items';
    if ($('#' + Drupal.advimage_ref.itemlist_id).length) {
      Drupal.advimage_ref.showButtonInit();
    } else {
      alert(
        Drupal.t("Advimage_ref widget is configured wrong.\nIt\'s intended for multiply selection.\nPlease tell about this error to your site administrator.") 
      );
    }
  }
  // runs when sorting started - bind events to click e.g
  Drupal.advimage_ref.sortableListStart = function (event, ui) {
    Drupal.advimage_ref.dropEventsForSelectedPane();
  }
  // runs when sorting stopped- unbind events to click e.g
  Drupal.advimage_ref.sortableListStop = function (event, ui) {
    setTimeout(Drupal.advimage_ref.setEventsForSelectedPane, 300);
    Drupal.advimage_ref.selectionPaneArrangeHiddens();
  }
  Drupal.advimage_ref.selectionPaneArrangeHiddens = function() {
    // #advimage-ref-js-widget-hidden-inputs - place inputs here
    // NOTE:
    // Examples of id values: edit-field-advgallery-0-nid-nid
    // Name values: field_advgallery[0], field_advgallery[1], etc.
    // Value values: empty  or 'Name [12345]' where 12345 nid we need
    var divs = $('#advimage-ref-js-widget-selected div.advimage-ref-selected-image').get();
    var i = 0;
    var s_html = '';
    var s_str = '';
    if(divs.length > 0) {
      $('div#advimage-ref-js-widget-hidden-inputs').html('');
      for(i = 0; i < divs.length; i++){
        var nid = divs[i].id.replace('advimage-ref-selected-image-', '');
        s_str = s_str +  ( (i > 0) ? ',' : '') + nid;
        s_html = s_html + '<input type="hidden" id="edit-field-advgallery-' 
          + i + '-nid-nid" name="field_advgallery[' ;
        s_html = s_html + i + '][nid][nid]" value="';
        s_html = s_html + Drupal.advimage_ref.loadedNodesCache[nid].title_escaped;
        s_html = s_html + ' [nid:' + nid + ']" />';
        // hidden weight item
        s_html = s_html + '<input type="hidden" name="field_advgallery[' + i + '][_weight]';
        s_html = s_html + ' id="edit-field-advgallery-' + i + '--weight"'
        s_html = s_html + ' value="' + i + '" />';
      }
      $('div#advimage-ref-js-widget-hidden-inputs').html(s_html);
      $('#advimage-ref-field-advgallery').val(s_str);
    } else {
      $('div#advimage-ref-js-widget-hidden-inputs').empty();
      $('#advimage-ref-field-advgallery').val('');
    }
  }
  /*
   * Display error instead of component if fail occured while form loading
   */
  Drupal.advimage_ref.DisplayErrorInsteadOfComponent = function(message) {
    $('div#advimage-ref-js-widget-header1, div#advimage-ref-js-widget-header2, div#advimage-ref-js-widget-selection, div#advimage-ref-js-widget-selected').hide(10);
    $('div#advimage-ref-js-widget-header1, div#advimage-ref-js-widget-header2, div#advimage-ref-js-widget-selection, div#advimage-ref-js-widget-selected').remove();
    $('div#advimage-ref-js-widget').append('<div id="advimage-ref-js-widget-error"></div>');
    $('div#advimage-ref-js-widget-error').html(message.replace(new RegExp("\n", 'g'), '<br />') );
  }
  /*
   * Fires on selection widget resize to make work more comfortable
   */
  Drupal.advimage_ref.renderSelectionWidget_resize = function() {
    if($('div#advimage-ref-js-widget-selection table.advimage-ref-selection').length > 0) {
      var tblh = $('div#advimage-ref-js-widget-selection table.advimage-ref-selection').height();
      var clnth = $('div#advimage-ref-js-widget-selection').attr('clientHeight');
      if(
        clnth < tblh 
      ) {
        $('div#advimage-ref-js-widget-selection').css(
          'height', 
          tblh + $('div#advimage-ref-js-widget-selection').height() - $('div#advimage-ref-js-widget-selection').attr('clientHeight')
        );
      }
    }
  }
  Drupal.advimage_ref.renderSelectionWidget_selection_td_hover = function() {
    var idx = $(this).parent().children('td,th').index( $(this))+1;
    if (idx > 0) {
        $('td:nth-child('+idx+')').addClass( 'advimage-ref-selection-td-hover' );
    }
  }
  Drupal.advimage_ref.renderSelectionWidget_selection_td_hover_off = function() {
    var idx = $(this).parent().children('td,th').index( $(this))+1;
    if ( idx > 0 ) {
        $('td:nth-child('+idx+')').removeClass( 'advimage-ref-selection-td-hover' );
    }
  }
  /*
   * Intended to open some links in the new window
   */
  Drupal.advimage_ref.openLinkInNewWindow = function() {
    window.open(this.href);
    return false;
  }
  /*
   * Event handler for case object is in reconstruction process
   */
  Drupal.advimage_ref.noopenLinkOrButton = function() {
    return false;
  }
  /*
   * Detach image from the document
   */
  Drupal.advimage_ref.selectedPaneRemoveImage = function() {
    var inid = this.rel;
    var nodestruct = Drupal.advimage_ref.loadedNodesCache[inid];
    Drupal.advimage_ref.dropEventsForSelectionPane();
    Drupal.advimage_ref.dropEventsForSelectedPane();
    $('div#advimage-ref-selected-image-' + inid).hide(10);
    $('div#advimage-ref-selected-image-' + inid).remove();
    var td_str1 = '<td class="advimage-ref-selection-image-preview" id="advimage-ref-selection-image-info-' +  nodestruct.nid + '">'
      + nodestruct.html_preview
      + '</td>';
    var td_str2 = '<td class="advimage-ref-selection-image-button" id="advimage-ref-selection-image-button-' 
      +  nodestruct.nid + '">' 
      + '<input type="button" name="advimage-ref-selection-image-button-add-' 
        + nodestruct.nid + '" value="' + Drupal.t('Add') + '" id="advimage-ref-selection-image-button-'
        + nodestruct.nid + '" rel="' + nodestruct.nid  + '"/>'
      + '</td>';
    $('#advimage-ref-js-widget-selection table.advimage-ref-selection tr.advimage-ref-selection-images').prepend(td_str1);
    $('#advimage-ref-js-widget-selection table.advimage-ref-selection tr.advimage-ref-selection-buttons').prepend(td_str2);
    Drupal.advimage_ref.setEventsForSelectedPane();
    Drupal.advimage_ref.setEventsForSelectionPane();
    Drupal.advimage_ref.selectionPaneArrangeHiddens();
    return false;
  }
  /***********************************************
   * DESCRIBE ALL FOR CORRECT WORK OF #advimage-ref-modal-frame
   */
  $.fn.advimage_ref_modalframe = function(options) {
    var defaults = {  
      animation: 'fadeAndPop', 
      animationspeed: 300,
      closeonbackgroundclick: true,
      dismissmodalclass: 'close-modal',
    };
    var options = $.extend({}, defaults, options);
    return this.each(function() {
      var modal = $(this),
      topMeasure  = 0 /*!!!!!!!!!! check this later parseInt(modal.css('top'))*/,
      topOffset = modal.height() + topMeasure,
      locked = false,
      modalBG = $('.advimage-ref-modal-bg');
      if(modalBG.length == 0) {
        modalBG = $('<div class="advimage-ref-modal-bg" />').insertAfter(modal);
      }
      modal.bind('advimage-ref-modal:open', function () {
        modalBG.unbind('click.modalEvent');
        modalBG.css('height', $('body').height() );
        $('.' + options.dismissmodalclass).unbind('click.modalEvent');
        if(!locked) {
          lockModal();
          if(options.animation == "fadeAndPop") {
            modal.css({'top': $(document).scrollTop()-topOffset, 'opacity' : 0, 'visibility' : 'visible'});
            modalBG.fadeIn(options.animationspeed/2);
            modal.animate({
              "top": $(document).scrollTop()+topMeasure + 'px',
              "opacity" : 1
            }, options.animationspeed,unlockModal());					
          }
          if(options.animation == "fade") {
            modal.css({'opacity' : 0, 'visibility' : 'visible', 'top': $(document).scrollTop()+topMeasure});
            modalBG.fadeIn(options.animationspeed/2);
            modal.animate({
              "opacity" : 1
            }, options.animationspeed,unlockModal());					
          } 
          if(options.animation == "none") {
            modal.css({'visibility' : 'visible', 'top':$(document).scrollTop()+topMeasure});
            modalBG.css({"display":"block"});	
            unlockModal();
          }
        }
        modal.unbind('advimage-ref-modal:open');
      }); 	
      modal.bind('advimage-ref-modal:close', function () {
        if(!locked) {
          lockModal();
          if(options.animation == "fadeAndPop") {
            modalBG.fadeOut(options.animationspeed);
            modalBG.css({'display' : 'none'});
            modal.animate(
              {
                "top":  $(document).scrollTop()-topOffset + 'px',
                "opacity" : 0
              }, 
              options.animationspeed/2,
              function() {
                modal.css({'top':topMeasure, 'opacity' : 1, 'visibility' : 'hidden'});
                unlockModal();
              }
            );
          }  	
          if(options.animation == "fade") {
            modalBG.fadeOut(options.animationspeed);
            modalBG.css({'display' : 'none'});
            modal.animate(
              {
                "opacity" : 0
              }, 
              options.animationspeed, 
              function() {
                modal.css({'opacity' : 1, 'visibility' : 'hidden', 'top' : topMeasure});
                unlockModal();
              }
            );			
          }  	
          if(options.animation == "none") {
            modal.css({'visibility' : 'hidden', 'top' : topMeasure});
            modalBG.css({'display' : 'none'});	
          }		
        }
        modal.unbind('advimage-ref-modal:close');
      });
      modal.trigger('advimage-ref-modal:open')

      var closeButton = $('.' + options.dismissmodalclass).bind('click.modalEvent', function () {
        modal.trigger('advimage-ref-modal:close')
      });

      if(options.closeonbackgroundclick) {
        modalBG.css({"cursor":"pointer"})
        modalBG.bind('click.modalEvent', function () {
          modal.trigger('advimage-ref-modal:close')
        });
      }
      
      $(window).keyup(function(e) {
        if(e.which===27){ 
          modal.trigger('advimage-ref-modal:close'); 
        } // 27 is the keycode for the Escape key
      });
      function unlockModal() { 
        locked = false;
      }
      function lockModal() {
        locked = true;
      }
    });
  }
  /*
   * END OF POPUP DEFINITION
   */
  /*
   * Closes modal frame
   */
  Drupal.advimage_ref.ModalFrameClose = function() {
    $('#advimage-ref-modal-frame').trigger('advimage-ref-modal:close');
  }
  /*
   * Another format was selected
   */
  Drupal.advimage_ref.ModalFrameFormatChange = function() {
    Drupal.advimage_ref.codeToInsert = undefined;
    if( $('div#advimage-ref-modal-frame-code-block').css('display') == 'none' ) {} else {
      $('div#advimage-ref-modal-frame-code-block').fadeOut(10);
      $('div#advimage-ref-modal-frame-code-block').empty();
      $('div#advimage-ref-modal-frame-code-block').css('display', 'none')
    }
  }
  /*
   * Another placement style was selected
   */
  Drupal.advimage_ref.ModalFramePlacementChange = function() {
    Drupal.advimage_ref.codeToInsert = undefined;
    if( $('div#advimage-ref-modal-frame-code-block').css('display') == 'none' ) {} else {
      $('div#advimage-ref-modal-frame-code-block').fadeOut(10);
      $('div#advimage-ref-modal-frame-code-block').empty();
      $('div#advimage-ref-modal-frame-code-block').css('display', 'none');
    }
  }
  /*
   * Wrapper for JSON data from server.
   * Will do filling format block, error checking.
   * Created because same code will be used 3 times
   */
  Drupal.advimage_ref.ModalFrameParseFormatJson = function(result) {
    var response = undefined;
    var message = '';
    try{
      response = Drupal.parseJson(result);
    }catch (e) {
      alert(
        Drupal.t('Error with server connection occured while initialization of images selection component. Please try reload this page to make all work properly.') 
      );
      return null;
    }
    if(response.result == 'error') {
      message = Drupal.t("Error occured during form loading:\n") 
        + response.message
        + "\n Try reload form to make all work correct. If error occures again please contact site administration";
      alert(message);
      Drupal.advimage_ref.ModalFrameClose();
      Drupal.advimage_ref.DisplayErrorInsteadOfComponent(message);
      return null;
    }
    if(response.result != 'success') {
      message = Drupal.t('Unknown error occured while form initialization. Please contact site administrator.');
      alert(message);
      Drupal.advimage_ref.ModalFrameClose();
      Drupal.advimage_ref.DisplayErrorInsteadOfComponent(message);
      return null;
    }
    // fill in that
    // $('div#advimage-ref-modal-frame-code-block')
    var data = response.data;
    Drupal.advimage_ref.codeToInsert = data.filtercodes;
    $('div#advimage-ref-modal-frame-code-block').text('');
    $('div#advimage-ref-modal-frame-code-block').append(
      '<div id="advimage-ref-modal-frame-code-bb"><div class="advimage-ref-modal-frame-code-title"></div><div class="advimage-ref-modal-frame-code-wrapper"></div></div>'
      + '<div id="advimage-ref-modal-frame-code-html"><div class="advimage-ref-modal-frame-code-title"></div><div class="advimage-ref-modal-frame-code-wrapper"></div></div>'
    );
    $('#advimage-ref-modal-frame-code-bb div.advimage-ref-modal-frame-code-title').text(
      Drupal.t('BB code tag:') 
    );
    $('#advimage-ref-modal-frame-code-html div.advimage-ref-modal-frame-code-title').text(
      Drupal.t('HTML code tag:') 
    );
    $('#advimage-ref-modal-frame-code-bb div.advimage-ref-modal-frame-code-wrapper').text(
      data.filtercodes.code
    );
    $('#advimage-ref-modal-frame-code-html div.advimage-ref-modal-frame-code-wrapper').text(
      data.filtercodes.html
    );
    return data;
  }
  /*
   * Called by show button to show code for insert
   */
  Drupal.advimage_ref.ModalFrameShowCodeJson = function(result) {
    var data = Drupal.advimage_ref.ModalFrameParseFormatJson(result);
    if(data) {
      $('div#advimage-ref-modal-frame-code-block').fadeIn(100);
      $('div#advimage-ref-modal-frame-code-block').css('display', 'block');
    }
  }
  /*
   * Prepares JSON url to fetch tag code
   */
  Drupal.advimage_ref.ModalFramePrepareCurrentInsertUrl = function() {
    var theme = '';
    var style = '';
    var i = 0;
    var inid = $('#advimage-ref-modal-frame').attr('inid');
    var nodestruct = Drupal.advimage_ref.loadedNodesCache[inid];
    i = $('#advimage-ref-modal-frame-format input.input-radio:checked').val();
    if ( (i >= 0) && (i < Drupal.settings.advimage_ref.imageformats.length) ) {
      theme = Drupal.settings.advimage_ref.imageformats[i].fname;
    }
    i = $('#advimage-ref-modal-frame-placements input.input-radio:checked').val();
    if ( (i >= 0) && (i < Drupal.settings.advimage_ref.imageplacementoptions.length) ) {
      style = Drupal.settings.advimage_ref.imageplacementoptions[i].name
    }
    if ( (theme != '') && (style != '') ) {
       return Drupal.settings.advimage_ref.imageformats_url + '/' + inid + '/' + theme + '/' + style;
    }
    return undefined;
  }
  /*
   * Show insert code on modal frame was pressed
   */
  Drupal.advimage_ref.ModalFrameShowCodePress = function() {
    var image_format_url = Drupal.advimage_ref.ModalFramePrepareCurrentInsertUrl();
    if(typeof(image_format_url) != 'undefined') {
      $('#advimage-ref-modal-frame-code-block').text(
        Drupal.t('Please wait, fetching information from server') 
      );
      $('#advimage-ref-modal-frame-code-block').fadeIn(100);
      $('div#advimage-ref-modal-frame-code-block').css('display', 'block');
      $.ajax({
        url: image_format_url,
        success: Drupal.advimage_ref.ModalFrameShowCodeJson,
        async:false
      });
    }
    return false;
  }
  /*
   * Additional function for tab panes
   * // some code was given from insert module(drupal.org/project/insert)
   */
  Drupal.advimage_ref.insertActivateTabPane = function(editor) {
    var $pane = $(editor).parents('.vertical-tabs-pane:first');
    var $panes = $pane.parent('.vertical-tabs-panes');
    var $tabs = $panes.parents('.vertical-tabs:first').find('ul.vertical-tabs-list:first li a');
    if ($pane.size() && $pane.is(':hidden') && $panes.size() && $tabs.size()) {
      var index = $panes.children().index($pane);
      $tabs.eq(index).click();
    }
  }
  /*
   * inserts at cursor in textarea
   * // some code was given from insert module(drupal.org/project/insert)
   */
  Drupal.advimage_ref.insertAtCursor = function(editor, content) {
    // Record the current scroll position.
    var scroll = editor.scrollTop;

    // IE support.
    if (document.selection) {
      editor.focus();
      sel = document.selection.createRange();
      sel.text = content;
    }

    // Mozilla/Firefox/Netscape 7+ support.
    else if (editor.selectionStart || editor.selectionStart == '0') {
      var startPos = editor.selectionStart;
      var endPos = editor.selectionEnd;
      editor.value = editor.value.substring(0, startPos) + content + editor.value.substring(endPos, editor.value.length);
    }

    // Fallback, just add to the end of the content.
    else {
      editor.value += content;
    }

    // Ensure the textarea does not unexpectedly scroll.
    editor.scrollTop = scroll;
  }
  /*
   * inserts code to editor, wysiwyg or something else
   * // some code was given from insert module(drupal.org/project/insert)
   */
  Drupal.advimage_ref.insertCodeIntoEditor = function(content) {
    var insertTextarea;
    if (typeof(insertTextarea) == 'undefined') {
      insertTextarea = $('#edit-body').get(0) || false;
    }
    // Always work in normal text areas that currently have focus.
    if (insertTextarea && insertTextarea.insertHasFocus) {
      Drupal.advimage_ref.insertAtCursor(insertTextarea, content);
    }
    // Direct tinyMCE support.
    else if (typeof(tinyMCE) != 'undefined' && tinyMCE.activeEditor) {
      Drupal.advimage_ref.insertActivateTabPane(document.getElementById(tinyMCE.activeEditor.editorId));
      tinyMCE.activeEditor.execCommand('mceInsertContent', false, content);
    }
    // WYSIWYG support, should work in all editors if available.
    else if (Drupal.wysiwyg && Drupal.wysiwyg.activeId) {
      Drupal.advimage_ref.insertActivateTabPane(document.getElementById(Drupal.wysiwyg.activeId));
      Drupal.wysiwyg.instances[Drupal.wysiwyg.activeId].insert(content)
    }
    // FCKeditor module support.
    else if (typeof(FCKeditorAPI) != 'undefined' && typeof(fckActiveId) != 'undefined') {
      Drupal.advimage_ref.insertActivateTabPane(document.getElementById(fckActiveId));
      FCKeditorAPI.Instances[fckActiveId].InsertHtml(content);
    }
    // Direct FCKeditor support (only body field supported).
    else if (typeof(FCKeditorAPI) != 'undefined') {
      // Try inserting into the body.
      if (FCKeditorAPI.Instances[insertTextarea.id]) {
        Drupal.advimage_ref.insertActivateTabPane(insertTextarea);
        FCKeditorAPI.Instances[insertTextarea.id].InsertHtml(content);
      }
      // Try inserting into the first instance we find (may occur with very
      // old versions of FCKeditor).
      else {
        for (var n in FCKeditorAPI.Instances) {
          Drupal.advimage_ref.insertActivateTabPane(document.getElementById(n));
          FCKeditorAPI.Instances[n].InsertHtml(content);
          break;
        }
      }
    }
    // Direct CKeditor support (only body field supported).
    else if (typeof(CKEDITOR) != 'undefined' && CKEDITOR.instances[insertTextarea.id]) {
      Drupal.advimage_ref.insertActivateTabPane(insertTextarea);
      CKEDITOR.instances[insertTextarea.id].insertHtml(content);
    }
    else if (insertTextarea) {
      Drupal.advimage_ref.insertActivateTabPane(insertTextarea);
      Drupal.advimage_ref.insertAtCursor(insertTextarea, content);
    }
    return false;
  }
  /*
   * JSON call to insert BB code
   */
  Drupal.advimage_ref.ModalFrameInsertCodeBBJson = function(result) {
    var data = Drupal.advimage_ref.ModalFrameParseFormatJson(result);
    if(data) {
      Drupal.advimage_ref.ModalFrameClose();
      Drupal.advimage_ref.insertCodeIntoEditor(Drupal.advimage_ref.codeToInsert.code);
    }
  }
  /*
   * JSON call to insert HTML code
   */
  Drupal.advimage_ref.ModalFrameInsertCodeHTMLJson = function(result) {
    var data = Drupal.advimage_ref.ModalFrameParseFormatJson(result);
    if(data) {
      Drupal.advimage_ref.ModalFrameClose();
      Drupal.advimage_ref.insertCodeIntoEditor(Drupal.advimage_ref.codeToInsert.html);
    }
  }
  /*
   * Insert image to document when BB button was pressed
   */
  Drupal.advimage_ref.ModalFrameInsertCodeBBPress = function() {
    if(typeof(Drupal.advimage_ref.codeToInsert) != 'undefined') {
      Drupal.advimage_ref.ModalFrameClose();
      Drupal.advimage_ref.insertCodeIntoEditor(Drupal.advimage_ref.codeToInsert.code);
    } else {
      var image_format_url = Drupal.advimage_ref.ModalFramePrepareCurrentInsertUrl();
      if(typeof(image_format_url) != 'undefined') {
        $.ajax({
          url: image_format_url,
          success: Drupal.advimage_ref.ModalFrameInsertCodeBBJson,
          async:false
        });
      }
    }
    return false;
  }
  
  /*
   * Insert image to document when HTML button was pressed
   */
  Drupal.advimage_ref.ModalFrameInsertCodeHTMLPress = function() {
    if(typeof(Drupal.advimage_ref.codeToInsert) != 'undefined') {
      Drupal.advimage_ref.ModalFrameClose();
      Drupal.advimage_ref.insertCodeIntoEditor(Drupal.advimage_ref.codeToInsert.html);
    } else {
      var image_format_url = Drupal.advimage_ref.ModalFramePrepareCurrentInsertUrl();
      if(typeof(image_format_url) != 'undefined') {
        $.ajax({
          url: image_format_url,
          success: Drupal.advimage_ref.ModalFrameInsertCodeHTMLJson,
          async:false
        });
      }
    }
    return false;
  }
  /*
   * Setup of events for the modal frame
   */ 
  Drupal.advimage_ref.setModalFrameEvents = function() {
    $('#advimage-ref-modal-frame-format input.input-radio[name="advimage-ref-modal-frame-format-option"]').change(
      Drupal.advimage_ref.ModalFrameFormatChange
    );
    $('#advimage-ref-modal-frame-placements input.input-radio[name="advimage-ref-modal-frame-placement-option"]').change(
      Drupal.advimage_ref.ModalFramePlacementChange
    );
    $('#advimage-ref-modal-frame-show-code-button').click(
      Drupal.advimage_ref.ModalFrameShowCodePress
    );
    $('#advimage-ref-modal-frame-insert-code-bb').click(
      Drupal.advimage_ref.ModalFrameInsertCodeBBPress
    );
    $('#advimage-ref-modal-frame-insert-code-html').click(
      Drupal.advimage_ref.ModalFrameInsertCodeHTMLPress
    );
  }
  /*
   * Start modal frame to Attach image to the document
   */
  Drupal.advimage_ref.selectedPaneInsertImage = function(e) {
    var inid = this.rel;
    var nodestruct = Drupal.advimage_ref.loadedNodesCache[inid];
    var length = Drupal.settings.advimage_ref.imageformats.length;
    var i = 0;
    Drupal.advimage_ref.codeToInsert = undefined;
    e.preventDefault();
    $('#advimage-ref-modal-frame').attr('inid', inid);
    if ($('#advimage-ref-modal-frame-internal').length  == 0) {
       $('#advimage-ref-modal-frame').append('<div id="advimage-ref-modal-frame-internal"></div>');
    }
    $('#advimage-ref-modal-frame-internal').empty();
    // now insert there variants
    $('#advimage-ref-modal-frame-internal').append('<h3 class="advimage-ref-modal-frame-insert"></h3>');
    $('#advimage-ref-modal-frame-internal h3.advimage-ref-modal-frame-insert').text(Drupal.t('Insert image into text') );
    $('#advimage-ref-modal-frame-internal').append(
      '<img src="' 
      + nodestruct.preview_url + '" alt=' 
      + nodestruct.title_escaped + '" title="' + nodestruct.title_escaped + '" class="advimage-ref-modal-frame-preview" />'
    );
    $('#advimage-ref-modal-frame-internal').append('<div id="advimage-ref-modal-frame-format"></div>');
    // now we work on this component
    $('#advimage-ref-modal-frame-format').append('<div class="advimage-ref-modal-formats-list"></div>');
    $('#advimage-ref-modal-frame-format div.advimage-ref-modal-formats-list').text(Drupal.t('Select format for insert') );
    $('#advimage-ref-modal-frame-format').append(
      '<div class="advimage-ref-modal-frame-format-wrapper"></div>'
    );
    length = Drupal.settings.advimage_ref.imageformats.length;
    var str1 = '';
    var _id = '';
    for(i = 0; i < length; i++) {
      _id = 'advimage-ref-modal-frame-format-id-' + i;
      str1 = str1 + '<div><label class="option" for="' + _id + '">'
        + '<input class="input-radio" type="radio" name="advimage-ref-modal-frame-format-option" id="' 
        +  _id +'" value="' + i + '"' 
        + (i ? '' : 'checked=checked') + '>' 
        + Drupal.settings.advimage_ref.imageformats[i].title_escaped 
        + '</label></div>'
    }
    $(
      '#advimage-ref-modal-frame-format div.advimage-ref-modal-frame-format-wrapper'
    ).append(str1);
    $('#advimage-ref-modal-frame-internal').append(
      '<div id="advimage-ref-modal-frame-placements"></div>'
    );
    $('#advimage-ref-modal-frame-placements').append(
      '<div class="advimage-ref-modal-frame-placements-list"></div>'
    );
    $(
      '#advimage-ref-modal-frame-placements div.advimage-ref-modal-frame-placements-list'
    ).append(
      Drupal.t('Select image placement variant')
    )
    $('#advimage-ref-modal-frame-placements').append(
      '<div class="advimage-ref-modal-frame-placements-wrapper"></div>'
    );
    length = Drupal.settings.advimage_ref.imageplacementoptions.length;
    str1 = '';
    for (i = 0; i < length; i ++) {
      _id = 'advimage-ref-modal-frame-placement-id-' + i;
      str1 = str1 + '<div><label class="option" for="' + _id + '">'
        + '<input class="input-radio" type="radio" name="advimage-ref-modal-frame-placement-option" id="' 
        +  _id +'" value="' + i + '"' 
        + (i ? '' : 'checked=checked') + '>' 
        + Drupal.settings.advimage_ref.imageplacementoptions[i].title_escaped 
        + '</label></div>';
    }
    $('#advimage-ref-modal-frame-placements div.advimage-ref-modal-frame-placements-wrapper').append(str1);
    $('#advimage-ref-modal-frame-internal').append('<div id="advimage-ref-modal-frame-buttons"></div>');
    $('div#advimage-ref-modal-frame-buttons').append(
      '<input type="button" name="advimage-ref-modal-frame-show-code" value="" id="advimage-ref-modal-frame-show-code-button" class="advimage-ref-modal-frame-show-code">'
      + '<input type="button" name="advimage-ref-modal-frame-insert-bbcode" value="" id="advimage-ref-modal-frame-insert-code-bb" class="advimage-ref-modal-frame-insert-code">'
      + '<input type="button" name="advimage-ref-modal-frame-insert-htmlcode" value="" id="advimage-ref-modal-frame-insert-code-html" class="advimage-ref-modal-frame-insert-code">'
    );
    $('#advimage-ref-modal-frame-show-code-button').val(Drupal.t('Show code') );
    $('#advimage-ref-modal-frame-insert-code-bb').val(Drupal.t('Insert image as BB code') );
    $('#advimage-ref-modal-frame-insert-code-html').val(Drupal.t('Insert as HTML code with filter tag') );
    $('#advimage-ref-modal-frame-internal').append('<div id="advimage-ref-modal-frame-code-block"></div>');
    $('div#advimage-ref-modal-frame-code-block').css('display', 'none');
    $('#advimage-ref-modal-frame').advimage_ref_modalframe({});
    Drupal.advimage_ref.setModalFrameEvents();
    return false;
  }
  Drupal.advimage_ref.setEventsForSelectedPane = function() {
    $('#advimage-ref-js-widget-selected .advimage-ref-selected-image a.advimage-ref-selected-opennew').click(Drupal.advimage_ref.openLinkInNewWindow);
    $('#advimage-ref-js-widget-selected .advimage-ref-selected-image a.advimage-ref-remove-attached-image').click(Drupal.advimage_ref.selectedPaneRemoveImage);
    $('#advimage-ref-js-widget-selected a.advimage-ref-insert-attached-image').click(Drupal.advimage_ref.selectedPaneInsertImage);
  }
  
  Drupal.advimage_ref.dropEventsForSelectedPane = function(){
    $('#advimage-ref-js-widget-selected .advimage-ref-selected-image a.advimage-ref-selected-opennew').unbind('click', Drupal.advimage_ref.openLinkInNewWindow);
    $('#advimage-ref-js-widget-selected .advimage-ref-selected-image a.advimage-ref-selected-opennew').click(Drupal.advimage_ref.noopenLinkOrButton);
    $('#advimage-ref-js-widget-selected .advimage-ref-selected-image a.advimage-ref-remove-attached-image').unbind('click', Drupal.advimage_ref.selectedPaneRemoveImage);
    $('#advimage-ref-js-widget-selected .advimage-ref-selected-image a.advimage-ref-remove-attached-image').click(Drupal.advimage_ref.noopenLinkOrButton);
    $('#advimage-ref-js-widget-selected a.advimage-ref-insert-attached-image').unbind('click', Drupal.advimage_ref.selectedPaneInsertImage);
    $('#advimage-ref-js-widget-selected a.advimage-ref-insert-attached-image').click(Drupal.advimage_ref.noopenLinkOrButton);
  }
  /*
   * Click to select image and add it to the document
   */
  Drupal.advimage_ref.selectionAddImageClick = function(){
    var inid = this.id.replace('advimage-ref-selection-image-button-', '');
    if(this.id == 'advimage-ref-selection-showmore-button') {
      return false;
    }
    var nodestruct = Drupal.advimage_ref.loadedNodesCache[inid];
    if(typeof(nodestruct) != undefined) {
      Drupal.advimage_ref.dropEventsForSelectionPane();
      $(
        '#advimage-ref-selection-image-info-' +  inid 
          + ', #advimage-ref-selection-image-button-' + inid 
      ).hide(100);
      $(
        '#advimage-ref-selection-image-info-' +  inid 
          + ', #advimage-ref-selection-image-button-' + inid 
      ).remove();
      // place image info into #advimage-ref-js-widget-selected
      Drupal.advimage_ref.dropEventsForSelectedPane();
      $('#advimage-ref-js-widget-selected').append(nodestruct.html_selected);
      Drupal.advimage_ref.setEventsForSelectedPane();
      Drupal.advimage_ref.setEventsForSelectionPane();
      Drupal.advimage_ref.selectionPaneArrangeHiddens();
      // after all check count of images in pane and preload other
      if(
        $('#advimage-ref-js-widget-selection tr.advimage-ref-selection-images td.advimage-ref-selection-image-preview').length <= 1
      ) {
        Drupal.advimage_ref.callShowMoreImagesJson();
      }
    }
    return false;
  }
  /*
   * Sets events for selection pane components
   */
  Drupal.advimage_ref.setEventsForSelectionPane = function() {
    $('div#advimage-ref-js-widget-selection table.advimage-ref-selection td').mouseover(
      Drupal.advimage_ref.renderSelectionWidget_selection_td_hover
    );
    $('div#advimage-ref-js-widget-selection table.advimage-ref-selection td').mouseout(
      Drupal.advimage_ref.renderSelectionWidget_selection_td_hover_off
    );
    $('div#advimage-ref-js-widget-selection a.advimage-ref-selection-clicknew').unbind('click');
    $('div#advimage-ref-js-widget-selection a.advimage-ref-selection-clicknew').click(
      Drupal.advimage_ref.openLinkInNewWindow
    );
    $('#advimage-ref-selection-showmore-button').click(Drupal.advimage_ref.selectionShowMoreClick);
    $('#advimage-ref-js-widget-selection .advimage-ref-selection-image-button input').click(
      Drupal.advimage_ref.selectionAddImageClick
    );
  }
  /*
   * Drops events for selection pane component
   */
  Drupal.advimage_ref.dropEventsForSelectionPane = function() {
    $('div#advimage-ref-js-widget-selection table.advimage-ref-selection td').unbind(
      'mouseover', 
      Drupal.advimage_ref.renderSelectionWidget_selection_td_hover
    );
    $('div#advimage-ref-js-widget-selection table.advimage-ref-selection td').unbind(
      'mouseout',
      Drupal.advimage_ref.renderSelectionWidget_selection_td_hover_off
    );
    $('div#advimage-ref-js-widget-selection a.advimage-ref-selection-clicknew').unbind(
      'click',
      Drupal.advimage_ref.openLinkInNewWindow
    );
    $('div#advimage-ref-js-widget-selection a.advimage-ref-selection-clicknew').click(
      Drupal.advimage_ref.noopenLinkOrButton
    );
    $('#advimage-ref-selection-showmore-button').unbind(
      'click',
      Drupal.advimage_ref.selectionShowMoreClick
    );
    $('#advimage-ref-js-widget-selection .advimage-ref-selection-image-button input').unbind(
      'click',
      Drupal.advimage_ref.selectionAddImageClick
    );
    $('#advimage-ref-js-widget-selection .advimage-ref-selection-image-button input').click(
      Drupal.advimage_ref.noopenLinkOrButton
    );
  }
  /*
   * render selection widget when we need that
   */
  Drupal.advimage_ref.renderSelectionWidget =  function(data) {
    Drupal.advimage_ref.moreavailable = data.moreavailable;
    if( $('div#advimage-ref-js-widget-selection table.advimage-ref-selection').length > 0) {
    } else {
      //if( data.images.length > 0 ) {
        $('div#advimage-ref-js-widget-selection').append(
          '<table class="advimage-ref-selection"><tbody><tr class="advimage-ref-selection-images"></tr><tr class="advimage-ref-selection-buttons"></tr></tbody></table>'
        );
        $('div#advimage-ref-js-widget-selection table.advimage-ref-selection').change(
          Drupal.advimage_ref.renderSelectionWidget_resize
        );
      //}
    }
    var td_str1 = ''; // images info
    var td_str2 = '';
    if(data.images.length > 0) {
      Drupal.advimage_ref.dropEventsForSelectionPane();
      Drupal.advimage_ref.selection_page ++;
      var diffWidth = $('td#advimage-ref-selection-showmore').attr('scrollWidth');
      if(diffWidth == undefined) diffWidth = 0;
      var oldWidth = $('div#advimage-ref-js-widget-selection').attr('scrollWidth');
      if(isNaN(oldWidth) ) {
        oldWidth = 0;
      } else {
        oldWidth = oldWidth - diffWidth;
      }
      for (var i in data.images) {
        Drupal.advimage_ref.loadedNodesCache[data.images[i].nid] = data.images[i];
        // adding different image info
        td_str1 = td_str1
          + '<td class="advimage-ref-selection-image-preview" id="advimage-ref-selection-image-info-' +  data.images[i].nid + '">'
          + data.images[i].html_preview
          + '</td>';
        td_str2 = td_str2 
          + '<td class="advimage-ref-selection-image-button" id="advimage-ref-selection-image-button-' +  data.images[i].nid + '">' 
          + '<input type="button" name="advimage-ref-selection-image-button-add-' 
            + data.images[i].nid + '" value="' + Drupal.t('Add') + '" id="advimage-ref-selection-image-button-'
            + data.images[i].nid + '" rel="' + data.images[i].nid  + '"/>'
          + '</td>';
      }
    }
    $('div#advimage-ref-js-widget-selection tr.advimage-ref-selection-images td[colspan="2"]').remove();
    td_str1 = td_str1 
      + '<td rowspan="2" class="advimage-ref-selection-image-button" id="advimage-ref-selection-showmore" colspan="2">' 
      + '<input name="advimage-ref-selection-showmore-input" id="advimage-ref-selection-showmore-button" type="button" value="' 
      + Drupal.t('More...') 
      + '" />'
      + '</td>';
    $('div#advimage-ref-js-widget-selection tr.advimage-ref-selection-images').append(td_str1);
    $('div#advimage-ref-js-widget-selection tr.advimage-ref-selection-buttons').append(td_str2);
    if(Drupal.advimage_ref.moreavailable) {} else {
      $('#advimage-ref-selection-showmore-button').attr('disabled', 'disabled');
      $('#advimage-ref-selection-showmore-button').after(
        '<span class="no-more-available"><br />'
          + Drupal.t('No more images are available for addition')
          + '</span>'
      );
    }
    $('div#advimage-ref-js-widget-selection table.advimage-ref-selection').change();
    // now buttons events
    if(Drupal.advimage_ref.callShowMoreByButton) {
      if(oldWidth) {
        $('div#advimage-ref-js-widget-selection').animate({scrollLeft: oldWidth}, 500);
      }
    }
    Drupal.advimage_ref.setEventsForSelectionPane();
  }
  Drupal.advimage_ref.selectionShowMoreClick =  function() {
    Drupal.advimage_ref.callShowMoreByButton = true;
    Drupal.advimage_ref.callShowMoreImagesJson();
    return false;
  }
  /*
   * Loads images to selection widget
   */
  Drupal.advimage_ref.showMoreImagesJson = function (result) {
    var response = undefined;
    try{
      response = Drupal.parseJson(result);
    }catch (e) {
      alert(
        Drupal.t('Error with server connection occured while initialization of images selection component. Please try reload this page to make all work properly.') 
      );
      return;
    }
    var message = '';
    if(response.result == 'error') {
      message = Drupal.t("Error occured during form loading:\n") 
        + response.message
        + "\n Try reload form to make all work correct. If error occures again please contact site administration";
      alert(message);
      Drupal.advimage_ref.DisplayErrorInsteadOfComponent(message);
      return;
    }
    if(response.result != 'success') {
      message = Drupal.t('Unknown error occured while form initialization. Please contact site administrator.');
      alert(message);
      Drupal.advimage_ref.DisplayErrorInsteadOfComponent(message);
      return;
    }
    Drupal.advimage_ref.renderSelectionWidget(response.data);
  }
  Drupal.advimage_ref.renderAttachedImages = function() {
    Drupal.advimage_ref.dropEventsForSelectedPane();
    if (Drupal.settings.advimage_ref.images_initially_attached_count > 0) {
      var html_s = '';
      for(i in Drupal.settings.advimage_ref.images_initially_attached) {
        Drupal.advimage_ref.loadedNodesCache[Drupal.settings.advimage_ref.images_initially_attached[i].nid] = Drupal.settings.advimage_ref.images_initially_attached[i];
        html_s = html_s + Drupal.settings.advimage_ref.images_initially_attached[i].html_selected;
      }
      $('#advimage-ref-js-widget-selected').append(html_s);
    }
    Drupal.advimage_ref.setEventsForSelectedPane();
  }
  Drupal.advimage_ref.callShowMoreImagesJson = function() {
    var jsonUrl = Drupal.settings.advimage_ref.showmoreimages_json_url 
      + '?page='
      + Drupal.advimage_ref.selection_page;
    $.ajax({
      url: jsonUrl,
      success: Drupal.advimage_ref.showMoreImagesJson,
      async:false
    });
  }
  Drupal.advimage_ref.showButtonInit = function() {
    $('#' + Drupal.advimage_ref.itemlist_id).after(
      '<div id="advimage-ref-js-widget-wrapper"><div id="advimage-ref-js-widget"></div></div>'
    );
    $('#' + Drupal.advimage_ref.itemlist_id).hide();
    $('#advimage-ref-js-widget').append(
      '<div id="advimage-ref-js-widget-hidden-inputs"></div>'
    );
    // выдерем оттуда input и заберем с собой
    var inputs = $('#' + Drupal.advimage_ref.itemlist_id + ' input.form-text').get();
    var i = 0;
    // NOTE:
    // Examples of id values: edit-field-advgallery-0-nid-nid
    // Name values: field_advgallery[0], field_advgallery[1], etc.
    // Value values: empty  or 'Name [12345]' where 12345 nid we need
    
    for(i = 0; i < inputs.length; i ++ ){
      var id = inputs[i].id;
      var name = inputs[i].name;
      var value = inputs[i].value;
      $('#' + inputs[i].id).remove();
      if(value == '') { // we're not interesting in empty form there
      } else {
        $('#advimage-ref-js-widget-hidden-inputs').append(
          '<input type="hidden" id="' + id + '" name="' + name + '"  value="" />'
        );
        $('#' + id).val(value);
        $('#advimage-ref-js-widget-hidden-inputs').append(
          '<input type="hidden" name="field_advgallery[' + i + '][_weight]'
          + ' id="edit-field-advgallery-' + i + '--weight"'
          + ' value="' + i + '" />');
      }
    }
    $('#' + Drupal.advimage_ref.itemlist_id).remove();
    // now draw our beautiful form with images
    $('#advimage-ref-js-widget').append('<div id="advimage-ref-js-widget-header1"></div>');
    $('#advimage-ref-js-widget').append('<div id="advimage-ref-js-widget-selection"></div>');
    $('#advimage-ref-js-widget').append('<div id="advimage-ref-js-widget-header2"></div>');
    $('#advimage-ref-js-widget').append(
      '<div id="advimage-ref-js-widget-selected-wrapper"><div id="advimage-ref-js-widget-selected"></div></div>'
    );
    $('#advimage-ref-js-widget').append('<div id="advimage-ref-modal-frame" class="advimage-ref-modal"></div>');
    $('#advimage-ref-modal-frame').append('<a class="close-modal">&#215;</a>');
    $('#advimage-ref-modal-frame').append('<div id="advimage-ref-modal-frame"></div>');
    $('div#advimage-ref-js-widget-header1').text(
      Drupal.t('Select images you want to use in document') 
    );
    $('div#advimage-ref-js-widget-header2').text(
      Drupal.t('Attached images') 
    );
    if(Drupal.advimage_ref.mouseWheel != undefined) {
      $('#advimage-ref-js-widget-selection').mousewheel(Drupal.advimage_ref.mouseWheel);
    }
    $('#advimage-ref-js-widget-selected').sortable( {
      scroll : true,
      delay : 30,
      start : Drupal.advimage_ref.sortableListStart,
      stop : Drupal.advimage_ref.sortableListStop
    } );
    Drupal.advimage_ref.renderAttachedImages();
    Drupal.advimage_ref.callShowMoreImagesJson();
  }
  Drupal.behaviors  = Drupal.behaviors || {};
  Drupal.behaviors.advimage_ref = function (context) {
    Drupal.advimage_ref.showButtonInit_init();
  }
}) (jQuery);
