<?php
/*
 *  Advimage nodereference widget module
 * (c) Ilya V. Azarov, brainstorm@brainstorm.name, 2011
 * Intended to add images to arctiles and give variants of code to insert them there.
 * Additional miscelanous API for filters.
 */
/*
 * returns list of formatting variants
 */
function _advimage_ref_get_formats($cache_clear = FALSE) {
  static $formats;
  if($cache_clear) {
    $formats = NULL;
    cache_clear_all('advimage_ref_formats', 'cache');
  }
  if(isset($formats) ) {
    return $formats;
  }
  if($fl = cache_get('advimage_ref_formats') ) {
    $formats = $fl;
    return $formats;
  }
  $result =  db_query('SELECT fname, weight, descr, templatetext, default_options FROM {advimage_ref} ORDER BY weight');
  $formats = array();
  while ($row = db_fetch_array($result) ) {
    $formats []= $row;
  }
  return $formats;
}
/*
 * Gets concrete format values
 */
function _advimage_ref_get_format($fname, $cache_clear = FALSE) {
  $formats = _advimage_ref_get_formats($cache_clear);
  foreach ($formats as $row) {
    if ($row['fname'] == $fname) {
      return $row;
    }
  }
  return NULL;
}
/*
 * Get description of all tokens used inside image format template html text
 */
function _advimage_ref_get_tokens_descriptions_array() {
  return array(
    '[inodeurl]' => t('URL to the node image'),
    '[imageurl]' => t('URL to original image'),
    '[imageurl_presetname]' => t('Imagecache url to image using imagecache preset \'presetname\''),
    '[imagenodetitle]' => t('Title of image node'),
    '[classes_link]' => t('CSS classes for link tags'),
    '[classes_image]' => t('CSS classes for image'),
    '[classes_linknew]' => t('CSS classes to open link in the new window'),
    '[imgstylehelper]' => t('Content of style attributte for image defined by module'),
  );
}

/*
 * 

/*
 * renders filter code for given image and given format
 * Returns array in 2 variants: just BB code, HTML commented coe with initial HTML preview(format processed html).
 */
function _advimage_ref_render_filter_codes($image,  $theme = 'original', $style = 'floatleft') {
  $code_s = 'advimage nid=' . $image['nid'] . ' theme=' . $theme . ' style=' . $style . '';
  return array(
    'code' => '[' . $code_s . ']', 
    'html' => '<' . $code_s . '>' 
      . theme('advimage_ref_filter_html', $image, $theme, $style) 
      . '</advimage>'
  );
}

/*
 * Returns ist of options available for placement in the system
 */
function _advimage_ref_available_placement_options() {
  return array(
    0 => array(
      'name' => 'floatleft', 'title' =>  t('Floating on the left from the text'),
      'imgstylehelper' => 'float:left;clear:left;',
    ),
    1 =>  array(
      'name' => 'floatright', 'title' =>  t('Floating on the right from the text'),
      'imgstylehelper' => 'float:right;clear:right;',
    ),
    2 => array(
      'name' => 'floatnone', 'title' =>  t('No alignment defined'),
      'imgstylehelper' => '',
    ),
  );
}
function _advimage_ref_available_placement_names() {
  return array(
    0 => 'floatleft',
    1 => 'floatright',
    2 => 'floatnone',
  );
}
/* 
 * image - at least an like array('nid' => ..., 'title' => ..., 'filepath' => ...,)
 */
function _advimage_ref_make_filter_html($image, $theme = 'original', $style = 'floatleft') {
  static $presetnames;
  if(!isset($presetnames) ) {
    $presetnames = array();
    if (function_exists('imagecache_presets') ) {
      $presets = imagecache_presets();
      foreach($presets as $preset) {
        $presetnames []= $preset['presetname'];
      }
    }
  }
  $replacements = array();
  $url_options = array('absolute' => TRUE);
  if(count($presetnames) ) {
    foreach($presetnames as $key) {
      $replacements['[imageurl_' . $key . '-raw]'] = imagecache_create_url($key, $image['filepath']);
      $replacements['[imageurl_' . $key . ']'] = check_plain($replacements['[imageurl_' . $key . '-raw]'] );
    }
  }
  $replacements['[imageurl-raw]'] = url($image['filepath'], $url_options);
  $replacements['[imageurl]'] =  check_plain($replacements['[imageurl-raw]'] );
  $replacements['[inodeurl-raw]'] = url('node/' . $image['nid'], $url_options);
  $replacements['[inodeurl]'] =  check_plain($replacements['[inodeurl-raw]'] );
  $replacements['[imagenodetitle-raw]'] = $image['title'];
  $replacements['[imagenodetitle]'] = check_plain($replacements['[imagenodetitle-raw]'] );
  $replacements['[classes_link-raw]'] = 'advimage-ref-image-link';
  $replacements['[classes_link]'] = $replacements['[classes_link-raw]'];
  $replacements['[classes_linknew-raw]'] = 'advimage-ref-image-link-new';
  $replacements['[classes_linknew]'] = 'advimage-ref-image-link-new';
  $format = _advimage_ref_get_format($theme);
  if (!$format) {
    $format = _advimage_ref_get_format('original');
  }
  if( !$format ) {
    // !!!! for future some error log here
    return '';
  }
  $options = _advimage_ref_available_placement_options();
  $option = $options[0];
  foreach($options as $key => $val) {
    if($val['name'] == $style) {
      $option = $val;
      break;
    }
  }
  $style = $option['name'];
  $replacements['[classes_image]'] = 'advimage-ref-image advimage-ref-image-' . $style;
  $replacements['[classes_image-raw]'] = $replacements['[classes_image]'];
  $replacements['[imgstylehelper]'] = $option['imgstylehelper'];
  $replacements['[imgstylehelper-raw]'] = $replacements['imgstylehelper'];
  return str_replace(array_keys($replacements), $replacements, $format['templatetext'] );
}


/*
 * Preprocesses advimage_ref tags in node body html - makes badly tags cleanup
 */
function _advimage_ref_preprocess_filter_tags($text) {
  return $text;
}

/*
 * Processes advimage_ref tags in node body html
 */
function _advimage_ref_process_filter_tags($text) {
  $matches = array();
  $matches = $matches1 = array();
  preg_match_all('#\<advimage([\d+a-zA-Z\= \'\"]+)*\>#', $text, $matches, PREG_OFFSET_CAPTURE);
  preg_match_all('#\</advimage>#', $text, $matches1, PREG_OFFSET_CAPTURE);
  if(count($matches[1] ) ) {
    $entries =  array();
    $nids = array();
    $nids_i = array(); // pairs nid => array of entries ids
    foreach($matches[1] as $i => $match) {
      // extract $nid from there
      $params = explode(' ', trim($match[0]) );;
      $values = array();
      foreach($params as $key => $value) {
        $m1 = explode('=', str_replace(array('\'', '"'), array('', ''), $value) );
        if(count($m1) == 2) {
          $values[$m1[0] ] = $m1[1];
        }
      }
      if(isset($values['nid'] ) && is_numeric($values['nid'] ) ) {
        $entries[$i] ['nid'] = $values['nid'];
        if(isset($values['theme'] ) ) {
          $entries[$i] ['theme'] = $values['theme'];
        } else {
          $entries[$i] ['theme'] = 'original';
        }
        if(isset($values['style'] ) ) {
          $entries[$i] ['style'] = $values['style'];
        } else {
          $entries[$i] ['style'] = 'floatleft';
        }
        $nid = $entries[$i] ['nid'];
        $entries[$i]['valid'] = FALSE;
        $nids[] = $nid;
        if(!is_array($nids_i[$nid] ) ) {
          $nids_i[$nid] = array();
        }
        $nids_i[$nid] []= $i;
      } 
    }
    $images = _advimage_ref_get_attached_images_list($nids, TRUE);
    foreach($images as $key => $image) {
      $nid = $image['nid'];
      if(is_array($nids_i[$nid] ) && count($nids_i[$nid] ) ) {
        foreach($nids_i[$nid] as $i) {
          $entries[$i]['valid'] = TRUE;
          $entries[$i]['image'] = $image;
        }
      }
      unset($images[$key] );
    }
    // now for all entriees we must determine replacement string $matches[0][$i][0] + ... + $matches1[0][$j][0];
    $rep0 = array();
    $rep1 = array();
    foreach ($entries as $i => $entry) {
      $ln1 = strlen($matches[0][$i][0] );
      $pos0 = $matches[0][$i][1];
      $pos1 = $matches[0][$i][1] + $ln1;
      $j = -1;
      $endvalue = null;
      foreach ($matches1[0] as $key => $value) {
        if($value[1] >= $pos1) {
          $endvalue = $value;
          break;
        }
      }
      // now calculating string
      $pos2 =  $endvalue[1];
      $ln2 = $pos2 -$pos1; // length of content
      $pos3 = strlen($endvalue[0] ) +  $endvalue[1];
      if($ln2 >= 0 ) {
        $stringtoreplace = substr($text, $pos0, $pos3 - $pos0);
      } else {
        $stringtoreplace = substr($text, $pos0);
      }
      $rep0[$i] = $stringtoreplace;
      if ($ln2 != 0){
        if ($entry['valid'] ) {
          $rep1[$i] = theme(
            'advimage_ref_filter_html', $entry['image'], $entry['theme'], $entry['style'] 
          );
        } else {
          $rep1[$i] = theme('advimage_ref_wrong_image', $matches[1][$i][0], $entry, $style);
        }
      }else{
        $rep1[$i] = ''; // empty tags go away
      }
    };
    $text = str_replace($rep0, $rep1, $text);
    unset($entries);
    unset($rep0);
    unset($rep1);
  }
  // [advimage tags
  preg_match_all('#\[advimage([\d+a-zA-Z\= \'\"]+)*\]#u', $text, $matches);
  if(isset($matches[1] ) && count($matches[1] ) ) {
    $entries =  array();
    $nids = array();
    $nids_i = array(); // pairs nid => array of entries ids
    foreach($matches[1] as $i => $match) {
      // extract $nid from there
      $params = explode(' ', trim($match) );
      $values = array();
      foreach($params as $key => $value) {
        $m1 = explode('=', str_replace(array('\'', '"'), array('', ''), $value) );
        if(count($m1) == 2) {
          $values[$m1[0] ] = $m1[1];
        }
      }
      if(isset($values['nid'] ) && is_numeric($values['nid'] ) ) {
        $entries[$i] ['nid'] = $values['nid'];
        if(isset($values['theme'] ) ) {
          $entries[$i] ['theme'] = $values['theme'];
        } else {
          $entries[$i] ['theme'] = 'original';
        }
        if(isset($values['style'] ) ) {
          $entries[$i] ['style'] = $values['style'];
        } else {
          $entries[$i] ['style'] = 'floatleft';
        }
        $nid = $entries[$i] ['nid'];
        $entries[$i]['valid'] = FALSE;
        $nids[] = $nid;
        if(!is_array($nids_i[$nid] ) ) {
          $nids_i[$nid] = array();
        }
        $nids_i[$nid] []= $i;
      } 
    }
    $images = _advimage_ref_get_attached_images_list($nids, TRUE);
    foreach($images as $key => $image) {
      $nid = $image['nid'];
      if(is_array($nids_i[$nid] ) && count($nids_i[$nid] ) ) {
        foreach($nids_i[$nid] as $i) {
          $entries[$i]['valid'] = TRUE;
          $entries[$i]['image'] = $image;
        }
      }
      unset($images[$key] );
    }
    $rep1 = array();
    foreach($entries as $i => $entry) {
      if($entry['valid'] ) {
        $rep1[$i] = theme(
          'advimage_ref_filter_html', $entry['image'], $entry['theme'], $entry['style'] 
        );
      } else {
        // no such image - return original tag
        $rep1[$i] = $matches[0][$i];
      }
      unset($entries[$i] );
    }
    $text = str_replace($matches[0], $rep1, $text);
  }
  return $text;
}
function theme_advimage_ref_wrong_image($tagparams, $theme, $style) {
  return '[advimage ' .  check_plain($tagparams) . ' Error:'  . t('Wrong images described') . ']';
}
/*
 * Wrapper for lighter future + that wil used for replacements by filters.
 * Know - that's bad but here we need theme level flexibility
 */
function theme_advimage_ref_filter_html($image, $theme = 'original', $style = 'floatleft') {
  return _advimage_ref_make_filter_html($image, $theme, $style);
}

/*
 * This is wrapper for future. For example for multilanguage sites
 * For example we will need change filters descriptions
 */
function theme_advimage_ref_preprocess_image_formats($formats) {
  // title, title_escaped is necessary to show in selection list
  // WARNING: WE NEED THIS FIELDS FOR CORRECT JS WORK
  // YOU CAN CHANGE THEM DEPENDING ON LANGUAGE ETC BUT THEY MUST BE PRESENTED IN ARRAY
  foreach($formats as $key => $format) {
    $formats[$key]['title'] = $format['fname'] . ': ' . $format['descr'];
    $formats[$key]['title_escaped'] =  check_plain($formats[$key]['title'] );
  }
  return $formats;
}

function theme_advimage_ref_available_placement_options($options) {
  // title, title_escaped is necessary to show in selection list
  // WARNING: WE NEED THIS FIELDS FOR CORRECT JS WORK
  // YOU CAN CHANGE THEM DEPENDING ON LANGUAGE ETC BUT THEY MUST BE PRESENTED IN ARRAY
  foreach($options as $key => $option) {
    $options[$key]['title_escaped'] = check_plain($options[$key]['title'] );
  }
  return $options;
}
