<?php
/*
 *  Advimage nodereference widget module
 * (c) Ilya V. Azarov, brainstorm@brainstorm.name, 2011
 * Intended to add images to arctiles and give variants of code to insert them there.
 * JSON menu calls
 */

/*
 * Theme image view in images selection list
 */
function theme_advimage_ref_edit_selection_preview($image) {
  $out = '';
  $out .= '<span  class="advimage-ref-selection-image">';
  // class advimage-ref-selection-clicknew intended for click event - open image node in new window
  // if you do not want that(want thickbox, lightbox helpers) - remove it in your custom theme function
  $out .= '<a class="advimage-ref-selection-clicknew" href="' . check_plain(url('node/' . $image['nid'] ) ) . '">';
  $out .= '<img src="' 
    . $image['preview_url']
    . '" alt="' . check_plain($image['title'] ) 
    . '" title="' . check_plain($image['title'] ) . '" />';
  $out .= '</a>';
  $out .= '</span>';
  return $out;
}
/*
 * Theme image view in selected images list
 */
function theme_advimage_ref_edit_selected_preview($image) {
  $out = '';
  $out .= '<div class="advimage-ref-selected-image" id="advimage-ref-selected-image-' 
  . $image['nid'] . '">';
  $out .= '<div class="advimage-ref-selected-image-wrapper">';
  $out .= l(
  '<img src="' 
    . $image['preview_url']
    . '" alt="' . check_plain($image['title'] ) 
    . '" title="' . check_plain($image['title'] ) . '" />',
  'node/' . $image['nid'],
  array(
    'html' => TRUE,
    'attributes' => array('class' => 'advimage-ref-selected-opennew'),
  )
  );
  $out .= '<h3>' 
  . l(
    $image['title'], 
    'node/' . $image['nid'], 
    array('attributes' => array('class' => 'advimage-ref-selected-opennew') )
  ) . '</h3>';
  $out .= '<div class="advimage-ref-selected-image-controls">'
  . '<ul><li class="advimage-ref-controls-list">'
  . '<a href="#" class="advimage-ref-remove-attached-image" rel="' . $image['nid'] . '">'
  . t('Remove') . '</a></li></ul></div>';
  $out .= '<div class="advimage-ref-filters-selection-box">'
    . '<a href="#" rel="' . $image['nid'] . '" class="advimage-ref-insert-attached-image">' 
    . t('Insert this image into article')  . '</a>'
    . '</div>';
  $out .= '</div>';
  $out .= '</div>';
  return $out;
}
/*
 * returns to browser JSON with available for addition list of images
 * images are of current user for current user
 */
function advimage_ref_getmoreimages_json($fieldname, $current_nid, $token_name, $token_value) {
  global $user;
  module_load_include('inc', 'advimage', 'advimage.edit');
  if( !_advimage_ref_check_token($token_name, $token_value) ) {
  drupal_json( array(
    'jsonrpc' => '2.0', 'result' => 'error', 
    'message' => t('Wrong form tokens for advimage_ref module') 
  ) );
  return;
  }
  /* all code resamples  advimage module code */
  $current_nid = intval($current_nid);
  $page =  intval($_GET['page'] );
  $total = _advimage_edit_get_free_images_count($current_nid);
  if ($current_nid && ($node = node_load(array('nid' => $current_nid) ) ) ) {
  } else {
    $node = NULL;
  }
  $moreavailable = $total >= ( ($page + 1) * ADVIMAGE_EDIT_PAGE_NUM );
  $images = _advimage_edit_get_free_images_array($node, $page);
  $moreavailable = $moreavailable && count($images);
  // now we do wrap some data to make all safe
  foreach($images as $key => $image) {
    $images[$key] = _advimage_ref_prepare_image_data($image);
  }
  drupal_json(array(
    'jsonrpc' => '2.0',
    'result' => 'success',
    'data' => array(
      'imageswerereturned' => count($images),
      'moreavailable' => $moreavailable,
      'images' => $images,
    )
  ) );
}
/*
 * Prepares image data to normal JSON appearance
 */
function _advimage_ref_prepare_image_data($image) {
  $newimage = $image;
  $newimage['preview_url'] = imagecache_create_url(
    ADVIMAGE_REF_PREVIEW_PRESET, $image['filepath'] 
  );
  $newimage['title_escaped'] = check_plain($image['title'] );
  $newimage['preview_url_escaped'] = check_plain($image['preview_url']  );
  $newimage['html_preview'] = theme('advimage_ref_edit_selection_preview', $newimage);
  $newimage['html_selected'] = theme('advimage_ref_edit_selected_preview', $newimage);
  return $newimage;
}
/*
 * Formats HTML and BB code or the given image and sends to client
 */
function advimage_ref_imageformats_json($fieldname, $current_nid, $token_name, $token_value, $image_nid, $theme, $style) {
  global $user;
  module_load_include('inc', 'advimage', 'advimage.edit');
  module_load_include('inc', 'advimage_ref', 'advimage_ref.api');
  if( !_advimage_ref_check_token($token_name, $token_value) ) {
    drupal_json( array(
      'jsonrpc' => '2.0', 'result' => 'error', 
      'message' => t('Wrong form tokens for advimage_ref module') 
    ) );
    return;
  }
  $images = array();
  if(is_numeric($image_nid) ) {
    $images = _advimage_ref_get_attached_images_list(array($image_nid) );
  }
  if(!count($images) ) {
    drupal_json( array(
      'jsonrpc' => '2.0', 'result' => 'error', 
      'message' => t(
        'Images was not found. May be somebody deleted it when you are working in current form.'
      ),
    ) );
    return;
  }
  $image = array_pop($images);
  $image = _advimage_ref_prepare_image_data($image);
  $theme = strtolower($theme);
  $style = strtolower($style);
  $formats = _advimage_ref_get_formats();
  $format = NULL;
  foreach ($formats as $f) {
    if ( $f['fname'] == $f['fname'] ) {
      $format = $f;
      break;
    }
  } 
  if (!$format) {
    $format = $formats[0];
  }
  $plcmnts = _advimage_ref_available_placement_names();
  if(!in_array($style, $plcmnts ) ) {
    $style = $plcmnts[0];
  }
  $filtercodes = _advimage_ref_render_filter_codes($image, $theme, $style);
  // searching for such image
  drupal_json(array(
    'jsonrpc' => '2.0',
    'result' => 'success',
    'data' => array(
      'filtercodes' => $filtercodes,
    )
  ) );
}
