# A Puppet module to add some Aegir-up-specific config

class aegir_up {
  notice("\n
          Running Puppet manifests to install and/or update Aegir.\n
          This may take awhile, so please be patient.
          For more detail on the operations being run, edit settings.rb,
          and set 'verbose = 1'.")

  group { 'aegir group':
    ensure => present,
    name   => $aegir_user,
    gid    => $gid,
    }

  user { 'aegir user':
    ensure => present,
    name   => $aegir_user,
    uid    => $uid,
    gid    => $aegir_user,
    home   => $aegir_root,
    groups => $aegir_web_group,
    }

  # Set some defaults, and make output less verbose
  if !$aegir_dev_build {
    Group { loglevel => 'info', }
    Package { loglevel => 'info', }
    Notify { loglevel => 'info', }
    User { loglevel => 'info', }
    File { /*owner => 0, group => 0,*/ mode => 0644, loglevel => 'info', }

    # Only use queue_runner in Aegir 1.x
    include aegir::queue_runner
  }
  if $aegir_dev_build {
    # hosting_queued is included in Aegir 2.x
    include aegir::queued
  }

  Exec { path  => [ "/bin/", "/sbin/" , "/usr/bin/", "/usr/sbin/" ], /*loglevel => 'info',*/ }
  
  file { '/etc/motd':
    content => "\n
                Welcome to your Aegir Hostmaster virtual machine!\n
                Built by Vagrant. Managed by Puppet.\n
                Developed and maintained by Ergon Logic Enterprises.\n"
  }

  import "common"

  include aegir

}
