# AEMET

Shows Weather information from Spanish locations integrating with AEMET, the Spanish Meteorological Agency.
Recommended for sites that shows information of specific cities or towns from Spain.

This module is NOT an official one and uses AEMET data from their <a href="https://opendata.aemet.es/centrodedescargas/inicio" title="Aemet OpenData API">OpenData API</a>.

## Features

<ul>
  <li>Allows adding a block showing weather information for a specific municipality.</li>
  <li>Provides services to perform requests to AEMET. This service can scalate according to future needings of Drupal sites.</lI>
</ul>

## Requirements

It is needed having an API key from Aemet. It can be requested at the <a href="https://opendata.aemet.es/centrodedescargas/inicio" title="Aemet OpenData API">Aemet OpenData page</a>.

## How to use

After installing Aemet, it is needed to add the API key at Configuration -> Web Services > Aemet

To show the weather information, go to 'Block Layout' and add the Block named 'Aemet Weather: Hourly prediction':

To configure the block, it is needed to specify the municipality code.

This code must be obtained from the <a target="_blank" href="https://www.ine.es/daco/daco42/codmun/diccionario24.xlsx">INE municipality list</a>. For any location, the code is build by joining the values of the columns CPRO and CMUN.

For example, the code for Albacete can be obtained by joining 02 and 003: 02003

After that , the block with the weather information must appear.

## Real time block configuration.

To display real time information from AEMET in sites with anonymous page cache, it is recommended using the<a href="https://www.drupal.org/project/block_ajax"> AJAX block </a>module. This module allows adding a specific block via AJAX, with possibilities of caching and automatic refresh.

## Customizations

To customize the output of the municipality weather block, it is possible replacing the weather-info SDC.

Also, there is a service that allows getting the hourly weather for a specific province, the aemet.client service. It is possible getting the hourly weather prediction for a municipality by running this code:

```php
      $aemetClient = \Drupal::service('aemet.client');
      $prediction = $aemetClient
        ->predictionsSpecific()
        ->getMunicipalityPredictionHourly('02003');
```

In case more endpoints from AEMET OpenData are needed feel free opening an issue.
