<?php

declare(strict_types=1);

namespace Drupal\aemet\Clients;

use Drupal\aemet\Model\PredictionSpecificHourly;

/**
 * Allows getting predictions at specific places: municipalities / mountains...
 */
final class PredictionsSpecific extends ClientBase {

  /**
   * Get the hourly prediction of a specific municipality.
   *
   * @param string $municipality
   *   Municipality. It is build by joining province code and municipality code.
   */
  public function getMunicipalityPredictionHourly(string $municipality) : PredictionSpecificHourly {
    return $this->doRequest(sprintf('/municipio/horaria/%s', $municipality), PredictionSpecificHourly::class);
  }

  /**
   * Get specific predictions base path.
   */
  protected function getBasePath(): string {
    return '/api/prediccion/especifica';
  }

}
