# SwaggerClient-php
AEMET OpenData es una API REST desarrollado por AEMET que permite la difusión y la reutilización de la información meteorológica y climatológica de la Agencia, en el sentido indicado en la Ley 18/2015, de 9 de julio, por la que se modifica la Ley 37/2007, de 16 de noviembre, sobre reutilización de la información del sector público. (IMPORTANTE: Para poder realizar peticiones, es necesario introducir en API Key haciendo clic en el círculo rojo de recurso REST).

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.0
- Build package: io.swagger.codegen.languages.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com//.git"
    }
  ],
  "require": {
    "/": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/SwaggerClient-php/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure API key authorization: api_key
$config = Swagger\Client\Configuration::getDefaultConfiguration()->setApiKey('api_key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Swagger\Client\Configuration::getDefaultConfiguration()->setApiKeyPrefix('api_key', 'Bearer');

$apiInstance = new Swagger\Client\Api\AvisosCapApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$fecha_ini_str = "fecha_ini_str_example"; // string | Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC)
$fecha_fin_str = "fecha_fin_str_example"; // string | Fecha Final (AAAA-MM-DDTHH:MM:SSUTC)

try {
    $result = $apiInstance->avisosDeFenmenosMeteorolgicosAdversosArchivo($fecha_ini_str, $fecha_fin_str);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AvisosCapApi->avisosDeFenmenosMeteorolgicosAdversosArchivo: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://opendata.aemet.es/opendata*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AvisosCapApi* | [**avisosDeFenmenosMeteorolgicosAdversosArchivo**](docs/Api/AvisosCapApi.md#avisosdefenmenosmeteorolgicosadversosarchivo) | **GET** /api/avisos_cap/archivo/fechaini/{fechaIniStr}/fechafin/{fechaFinStr} | Avisos de Fenómenos Meteorológicos Adversos. Archivo.
*AvisosCapApi* | [**avisosDeFenmenosMeteorolgicosAdversosLtimo_**](docs/Api/AvisosCapApi.md#avisosdefenmenosmeteorolgicosadversosltimo_) | **GET** /api/avisos_cap/ultimoelaborado/area/{area} | Avisos de Fenómenos Meteorológicos Adversos. Último.
*IndicesIncendiosApi* | [**mapaDeNivelesDeRiesgoEstimadoMeteorolgicoDeIncendiosForestales_**](docs/Api/IndicesIncendiosApi.md#mapadenivelesderiesgoestimadometeorolgicodeincendiosforestales_) | **GET** /api/incendios/mapasriesgo/estimado/area/{area} | Mapa de niveles de riesgo estimado meteorológico de incendios forestales.
*IndicesIncendiosApi* | [**mapaDeNivelesDeRiesgoPrevistoMeteorolgicoDeIncendiosForestales_**](docs/Api/IndicesIncendiosApi.md#mapadenivelesderiesgoprevistometeorolgicodeincendiosforestales_) | **GET** /api/incendios/mapasriesgo/previsto/dia/{dia}/area/{area} | Mapa de niveles de riesgo previsto meteorológico de incendios forestales.
*InformacionSateliteApi* | [**ndiceNormalizadoDeVegetacin_**](docs/Api/InformacionSateliteApi.md#ndicenormalizadodevegetacin_) | **GET** /api/satelites/producto/nvdi | Índice normalizado de vegetación.
*InformacionSateliteApi* | [**temperaturaDelAguaDelMar_**](docs/Api/InformacionSateliteApi.md#temperaturadelaguadelmar_) | **GET** /api/satelites/producto/sst | Temperatura del agua del mar.
*MaestroApi* | [**getMunicipioUsingGET**](docs/Api/MaestroApi.md#getmunicipiousingget) | **GET** /api/maestro/municipio/{municipio} | getMunicipio
*MaestroApi* | [**getMunicipiosUsingGET**](docs/Api/MaestroApi.md#getmunicipiosusingget) | **GET** /api/maestro/municipios | getMunicipios
*MapasYGraficosApi* | [**mapasDeAnlisisLtimaPasada_**](docs/Api/MapasYGraficosApi.md#mapasdeanlisisltimapasada_) | **GET** /api/mapasygraficos/analisis | Mapas de análisis. Última pasada.
*MapasYGraficosApi* | [**mapasSignificativosTiempoActual1**](docs/Api/MapasYGraficosApi.md#mapassignificativostiempoactual1) | **GET** /api/mapasygraficos/mapassignificativos/{ambito}/{dia} | Mapas significativos. Tiempo actual.
*MapasYGraficosApi* | [**mapasSignificativosTiempoActual_**](docs/Api/MapasYGraficosApi.md#mapassignificativostiempoactual_) | **GET** /api/mapasygraficos/mapassignificativos/fecha/{fecha}/{ambito}/{dia} | Mapas significativos. Tiempo actual.
*ObservacionConvencionalApi* | [**datosDeObservacinTiempoActual1**](docs/Api/ObservacionConvencionalApi.md#datosdeobservacintiempoactual1) | **GET** /api/observacion/convencional/datos/estacion/{idema} | Datos de observación. Tiempo actual.
*ObservacionConvencionalApi* | [**datosDeObservacinTiempoActual_**](docs/Api/ObservacionConvencionalApi.md#datosdeobservacintiempoactual_) | **GET** /api/observacion/convencional/todas | Datos de observación. Tiempo actual.
*ObservacionConvencionalApi* | [**mensajesDeObservacinLtimoElaborado_**](docs/Api/ObservacionConvencionalApi.md#mensajesdeobservacinltimoelaborado_) | **GET** /api/observacion/convencional/mensajes/tipomensaje/{tipomensaje} | Mensajes de observación. Último elaborado.
*PrediccionMaritimaApi* | [**prediccinMartimaCostera_**](docs/Api/PrediccionMaritimaApi.md#prediccinmartimacostera_) | **GET** /api/prediccion/maritima/costera/costa/{costa} | Predicción marítima costera.
*PrediccionMaritimaApi* | [**prediccinMartimaDeAltaMar_**](docs/Api/PrediccionMaritimaApi.md#prediccinmartimadealtamar_) | **GET** /api/prediccion/maritima/altamar/area/{area} | Predicción marítima de alta mar.
*PrediccionesEspecificasApi* | [**informacionNivologica_**](docs/Api/PrediccionesEspecificasApi.md#informacionnivologica_) | **GET** /api/prediccion/especifica/nivologica/{area} | Información nivológica.
*PrediccionesEspecificasApi* | [**prediccinDeMontaaTiempoActual_**](docs/Api/PrediccionesEspecificasApi.md#prediccindemontaatiempoactual_) | **GET** /api/prediccion/especifica/montaña/pasada/area/{area}/dia/{dia} | Predicción de montaña. Tiempo actual.
*PrediccionesEspecificasApi* | [**prediccinDeMontaaTiempoPasado_**](docs/Api/PrediccionesEspecificasApi.md#prediccindemontaatiempopasado_) | **GET** /api/prediccion/especifica/montaña/pasada/area/{area} | Predicción de montaña. Tiempo pasado.
*PrediccionesEspecificasApi* | [**prediccinDeRadiacinUltravioletaUVI_**](docs/Api/PrediccionesEspecificasApi.md#prediccinderadiacinultravioletauvi_) | **GET** /api/prediccion/especifica/uvi/{dia} | Predicción de radiación ultravioleta (UVI).
*PrediccionesEspecificasApi* | [**prediccinParaLasPlayasTiempoActual_**](docs/Api/PrediccionesEspecificasApi.md#prediccinparalasplayastiempoactual_) | **GET** /api/prediccion/especifica/playa/{playa} | Predicción para las playas. Tiempo actual.
*PrediccionesEspecificasApi* | [**prediccinPorMunicipiosDiariaTiempoActual_**](docs/Api/PrediccionesEspecificasApi.md#prediccinpormunicipiosdiariatiempoactual_) | **GET** /api/prediccion/especifica/municipio/diaria/{municipio} | Predicción por municipios diaria. Tiempo actual.
*PrediccionesEspecificasApi* | [**prediccinPorMunicipiosHorariaTiempoActual_**](docs/Api/PrediccionesEspecificasApi.md#prediccinpormunicipioshorariatiempoactual_) | **GET** /api/prediccion/especifica/municipio/horaria/{municipio} | Predicción por municipios horaria. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAHoyArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaahoyarchivo_) | **GET** /api/prediccion/ccaa/hoy/{ccaa}/elaboracion/{fecha} | Predicción CCAA hoy. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAHoyTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaahoytiempoactual_) | **GET** /api/prediccion/ccaa/hoy/{ccaa} | Predicción CCAA hoy. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAMaanaArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaamaanaarchivo_) | **GET** /api/prediccion/ccaa/manana/{ccaa}/elaboracion/{fecha} | Predicción CCAA mañana. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAMaanaTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaamaanatiempoactual_) | **GET** /api/prediccion/ccaa/manana/{ccaa} | Predicción CCAA mañana. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAMedioPlazoArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaamedioplazoarchivo_) | **GET** /api/prediccion/ccaa/medioplazo/{ccaa}/elaboracion/{fecha} | Predicción CCAA medio plazo. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAMedioPlazoTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaamedioplazotiempoactual_) | **GET** /api/prediccion/ccaa/medioplazo/{ccaa} | Predicción CCAA medio plazo. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAPasadoMaanaArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaapasadomaanaarchivo_) | **GET** /api/prediccion/ccaa/pasadomanana/{ccaa}/elaboracion/{fecha} | Predicción CCAA pasado mañana. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinCCAAPasadoMaanaTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinccaapasadomaanatiempoactual_) | **GET** /api/prediccion/ccaa/pasadomanana/{ccaa} | Predicción CCAA pasado mañana. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalHoyArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalhoyarchivo_) | **GET** /api/prediccion/nacional/hoy/elaboracion/{fecha} | Predicción nacional hoy. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalHoyTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalhoytiempoactual_) | **GET** /api/prediccion/nacional/hoy | Predicción nacional hoy. Última elaborada.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalMaanaArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalmaanaarchivo_) | **GET** /api/prediccion/nacional/manana/elaboracion/{fecha} | Predicción nacional mañana. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalMaanaTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalmaanatiempoactual_) | **GET** /api/prediccion/nacional/manana | Predicción nacional mañana. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalMedioPlazoArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalmedioplazoarchivo_) | **GET** /api/prediccion/nacional/medioplazo/elaboracion/{fecha} | Predicción nacional medio plazo. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalMedioPlazoTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalmedioplazotiempoactual_) | **GET** /api/prediccion/nacional/medioplazo | Predicción nacional medio plazo. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalPasadoMaanaArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalpasadomaanaarchivo_) | **GET** /api/prediccion/nacional/pasadomanana/elaboracion/{fecha} | Predicción nacional pasado mañana. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalPasadoMaanaTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionalpasadomaanatiempoactual_) | **GET** /api/prediccion/nacional/pasadomanana | Predicción nacional pasado mañana. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalTendenciaArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionaltendenciaarchivo_) | **GET** /api/prediccion/nacional/tendencia/elaboracion/{fecha} | Predicción nacional tendencia. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinNacionalTendenciaTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinnacionaltendenciatiempoactual_) | **GET** /api/prediccion/nacional/tendencia | Predicción nacional tendencia. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinProvinciaHoyArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinprovinciahoyarchivo_) | **GET** /api/prediccion/provincia/hoy/{provincia}/elaboracion/{fecha} | Predicción provincia hoy. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinProvinciaHoyTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinprovinciahoytiempoactual_) | **GET** /api/prediccion/provincia/hoy/{provincia} | Predicción provincia hoy. Tiempo actual.
*PrediccionesNormalizadasTextoApi* | [**prediccinProvinciaMaanaArchivo_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinprovinciamaanaarchivo_) | **GET** /api/prediccion/provincia/manana/{provincia}/elaboracion/{fecha} | Predicción provincia mañana. Archivo.
*PrediccionesNormalizadasTextoApi* | [**prediccinProvinciaMaanaTiempoActual_**](docs/Api/PrediccionesNormalizadasTextoApi.md#prediccinprovinciamaanatiempoactual_) | **GET** /api/prediccion/provincia/manana/{provincia} | Predicción provincia mañana. Tiempo actual.
*ProductosClimatologicosApi* | [**balanceHdricoNacionalDocumento_**](docs/Api/ProductosClimatologicosApi.md#balancehdriconacionaldocumento_) | **GET** /api/productos/climatologicos/balancehidrico/{anio}/{decena} | Balance hídrico nacional (documento).
*ProductosClimatologicosApi* | [**capasSHAPEDeEstacionesClimatolgicas_**](docs/Api/ProductosClimatologicosApi.md#capasshapedeestacionesclimatolgicas_) | **GET** /api/productos/climatologicos/capasshape/{tipoestacion} | Capas SHAPE de estaciones climatológicas de AEMET.
*ProductosClimatologicosApi* | [**resumenMensualClimatolgicoNacionalDocumento_**](docs/Api/ProductosClimatologicosApi.md#resumenmensualclimatolgiconacionaldocumento_) | **GET** /api/productos/climatologicos/resumenclimatologico/nacional/{anio}/{mes} | Resumen mensual climatológico nacional (documento).
*RedRadaresApi* | [**imagenComposicinNacionalRadaresTiempoActualEstndar_**](docs/Api/RedRadaresApi.md#imagencomposicinnacionalradarestiempoactualestndar_) | **GET** /api/red/radar/nacional | Imagen composición nacional radares. Tiempo actual estándar.
*RedRadaresApi* | [**radarRegional**](docs/Api/RedRadaresApi.md#radarregional) | **GET** /api/red/radar/regional/{radar} | Imagen gráfica radar regional. Tiempo actual estándar.
*RedRayosApi* | [**mapaConLosRayosRegistradosEnPeriodoStandardLtimoElaborado_**](docs/Api/RedRayosApi.md#mapaconlosrayosregistradosenperiodostandardltimoelaborado_) | **GET** /api/red/rayos/mapa | Mapa con los rayos registrados en periodo standard. Último elaborado.
*RedesEspecialesApi* | [**contenidoTotalDeOzonoTiempoActual_**](docs/Api/RedesEspecialesApi.md#contenidototaldeozonotiempoactual_) | **GET** /api/red/especial/ozono | Contenido total de ozono. Tiempo actual.
*RedesEspecialesApi* | [**datosDeContaminacinDeFondoTiempoActual_**](docs/Api/RedesEspecialesApi.md#datosdecontaminacindefondotiempoactual_) | **GET** /api/red/especial/contaminacionfondo/estacion/{nombre_estacion} | Datos de contaminación de fondo. Tiempo actual.
*RedesEspecialesApi* | [**datosDeRadiacinGlobalDirectaODifusaTiempoActual_**](docs/Api/RedesEspecialesApi.md#datosderadiacinglobaldirectaodifusatiempoactual_) | **GET** /api/red/especial/radiacion | Datos de radiación global, directa o difusa. Tiempo actual.
*RedesEspecialesApi* | [**perfilesVerticalesDeOzonoTiempoActual_**](docs/Api/RedesEspecialesApi.md#perfilesverticalesdeozonotiempoactual_) | **GET** /api/red/especial/perfilozono/estacion/{estacion} | Perfiles verticales de ozono. Tiempo actual.
*ValoresClimatologicosApi* | [**climatologasDiarias1**](docs/Api/ValoresClimatologicosApi.md#climatologasdiarias1) | **GET** /api/valores/climatologicos/diarios/datos/fechaini/{fechaIniStr}/fechafin/{fechaFinStr}/todasestaciones | Climatologías diarias.
*ValoresClimatologicosApi* | [**climatologasDiarias_**](docs/Api/ValoresClimatologicosApi.md#climatologasdiarias_) | **GET** /api/valores/climatologicos/diarios/datos/fechaini/{fechaIniStr}/fechafin/{fechaFinStr}/estacion/{idema} | Climatologías diarias.
*ValoresClimatologicosApi* | [**climatologasMensualesAnuales_**](docs/Api/ValoresClimatologicosApi.md#climatologasmensualesanuales_) | **GET** /api/valores/climatologicos/mensualesanuales/datos/anioini/{anioIniStr}/aniofin/{anioFinStr}/estacion/{idema} | Climatologías mensuales anuales.
*ValoresClimatologicosApi* | [**climatologasNormales19812010_**](docs/Api/ValoresClimatologicosApi.md#climatologasnormales19812010_) | **GET** /api/valores/climatologicos/normales/estacion/{idema} | Climatologías normales (1981-2010).
*ValoresClimatologicosApi* | [**estacionesPorIndicativo_**](docs/Api/ValoresClimatologicosApi.md#estacionesporindicativo_) | **GET** /api/valores/climatologicos/inventarioestaciones/estaciones/{estaciones} | Estaciones por indicativo.
*ValoresClimatologicosApi* | [**inventarioDeEstacionesValoresClimatolgicos_**](docs/Api/ValoresClimatologicosApi.md#inventariodeestacionesvaloresclimatolgicos_) | **GET** /api/valores/climatologicos/inventarioestaciones/todasestaciones | Inventario de estaciones (valores climatológicos).
*ValoresClimatologicosApi* | [**valoresExtremos_**](docs/Api/ValoresClimatologicosApi.md#valoresextremos_) | **GET** /api/valores/climatologicos/valoresextremos/parametro/{parametro}/estacion/{idema} | Valores extremos.


## Documentation For Models

 - [Model200](docs/Model/Model200.md)
 - [Model401](docs/Model/Model401.md)
 - [Model404](docs/Model/Model404.md)
 - [Model429](docs/Model/Model429.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## Author




