<?php
/**
 * ValoresClimatologicosApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * AEMET OpenData
 *
 * AEMET OpenData es una API REST desarrollado por AEMET que permite la difusión y la reutilización de la información meteorológica y climatológica de la Agencia, en el sentido indicado en la Ley 18/2015, de 9 de julio, por la que se modifica la Ley 37/2007, de 16 de noviembre, sobre reutilización de la información del sector público. (IMPORTANTE: Para poder realizar peticiones, es necesario introducir en API Key haciendo clic en el círculo rojo de recurso REST).
 *
 * OpenAPI spec version: 2.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.0
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Swagger\Client\ApiException;
use Swagger\Client\Configuration;
use Swagger\Client\HeaderSelector;
use Swagger\Client\ObjectSerializer;

/**
 * ValoresClimatologicosApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ValoresClimatologicosApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation climatologasDiarias1
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\Model200
     */
    public function climatologasDiarias1($fecha_ini_str, $fecha_fin_str)
    {
        list($response) = $this->climatologasDiarias1WithHttpInfo($fecha_ini_str, $fecha_fin_str);
        return $response;
    }

    /**
     * Operation climatologasDiarias1WithHttpInfo
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\Model200, HTTP status code, HTTP response headers (array of strings)
     */
    public function climatologasDiarias1WithHttpInfo($fecha_ini_str, $fecha_fin_str)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasDiarias1Request($fecha_ini_str, $fecha_fin_str);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model401',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model429',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation climatologasDiarias1Async
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasDiarias1Async($fecha_ini_str, $fecha_fin_str)
    {
        return $this->climatologasDiarias1AsyncWithHttpInfo($fecha_ini_str, $fecha_fin_str)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation climatologasDiarias1AsyncWithHttpInfo
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasDiarias1AsyncWithHttpInfo($fecha_ini_str, $fecha_fin_str)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasDiarias1Request($fecha_ini_str, $fecha_fin_str);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'climatologasDiarias1'
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function climatologasDiarias1Request($fecha_ini_str, $fecha_fin_str)
    {
        // verify the required parameter 'fecha_ini_str' is set
        if ($fecha_ini_str === null || (is_array($fecha_ini_str) && count($fecha_ini_str) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fecha_ini_str when calling climatologasDiarias1'
            );
        }
        // verify the required parameter 'fecha_fin_str' is set
        if ($fecha_fin_str === null || (is_array($fecha_fin_str) && count($fecha_fin_str) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fecha_fin_str when calling climatologasDiarias1'
            );
        }

        $resourcePath = '/api/valores/climatologicos/diarios/datos/fechaini/{fechaIniStr}/fechafin/{fechaFinStr}/todasestaciones';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($fecha_ini_str !== null) {
            $resourcePath = str_replace(
                '{' . 'fechaIniStr' . '}',
                ObjectSerializer::toPathValue($fecha_ini_str),
                $resourcePath
            );
        }
        // path params
        if ($fecha_fin_str !== null) {
            $resourcePath = str_replace(
                '{' . 'fechaFinStr' . '}',
                ObjectSerializer::toPathValue($fecha_fin_str),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation climatologasDiarias_
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $idema Indicativo climatológico de la EMA. Puede introducir varios indicativos separados por comas (,) (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\Model200
     */
    public function climatologasDiarias_($fecha_ini_str, $fecha_fin_str, $idema)
    {
        list($response) = $this->climatologasDiarias_WithHttpInfo($fecha_ini_str, $fecha_fin_str, $idema);
        return $response;
    }

    /**
     * Operation climatologasDiarias_WithHttpInfo
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $idema Indicativo climatológico de la EMA. Puede introducir varios indicativos separados por comas (,) (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\Model200, HTTP status code, HTTP response headers (array of strings)
     */
    public function climatologasDiarias_WithHttpInfo($fecha_ini_str, $fecha_fin_str, $idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasDiarias_Request($fecha_ini_str, $fecha_fin_str, $idema);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model401',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model429',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation climatologasDiarias_Async
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $idema Indicativo climatológico de la EMA. Puede introducir varios indicativos separados por comas (,) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasDiarias_Async($fecha_ini_str, $fecha_fin_str, $idema)
    {
        return $this->climatologasDiarias_AsyncWithHttpInfo($fecha_ini_str, $fecha_fin_str, $idema)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation climatologasDiarias_AsyncWithHttpInfo
     *
     * Climatologías diarias.
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $idema Indicativo climatológico de la EMA. Puede introducir varios indicativos separados por comas (,) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasDiarias_AsyncWithHttpInfo($fecha_ini_str, $fecha_fin_str, $idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasDiarias_Request($fecha_ini_str, $fecha_fin_str, $idema);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'climatologasDiarias_'
     *
     * @param  string $fecha_ini_str Fecha Inicial (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $fecha_fin_str Fecha Final (AAAA-MM-DDTHH:MM:SSUTC) (required)
     * @param  string $idema Indicativo climatológico de la EMA. Puede introducir varios indicativos separados por comas (,) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function climatologasDiarias_Request($fecha_ini_str, $fecha_fin_str, $idema)
    {
        // verify the required parameter 'fecha_ini_str' is set
        if ($fecha_ini_str === null || (is_array($fecha_ini_str) && count($fecha_ini_str) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fecha_ini_str when calling climatologasDiarias_'
            );
        }
        // verify the required parameter 'fecha_fin_str' is set
        if ($fecha_fin_str === null || (is_array($fecha_fin_str) && count($fecha_fin_str) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fecha_fin_str when calling climatologasDiarias_'
            );
        }
        // verify the required parameter 'idema' is set
        if ($idema === null || (is_array($idema) && count($idema) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $idema when calling climatologasDiarias_'
            );
        }

        $resourcePath = '/api/valores/climatologicos/diarios/datos/fechaini/{fechaIniStr}/fechafin/{fechaFinStr}/estacion/{idema}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($fecha_ini_str !== null) {
            $resourcePath = str_replace(
                '{' . 'fechaIniStr' . '}',
                ObjectSerializer::toPathValue($fecha_ini_str),
                $resourcePath
            );
        }
        // path params
        if ($fecha_fin_str !== null) {
            $resourcePath = str_replace(
                '{' . 'fechaFinStr' . '}',
                ObjectSerializer::toPathValue($fecha_fin_str),
                $resourcePath
            );
        }
        // path params
        if ($idema !== null) {
            $resourcePath = str_replace(
                '{' . 'idema' . '}',
                ObjectSerializer::toPathValue($idema),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation climatologasMensualesAnuales_
     *
     * Climatologías mensuales anuales.
     *
     * @param  string $anio_ini_str Año Inicial (AAAA) (required)
     * @param  string $anio_fin_str Año Final (AAAA) (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\Model200
     */
    public function climatologasMensualesAnuales_($anio_ini_str, $anio_fin_str, $idema)
    {
        list($response) = $this->climatologasMensualesAnuales_WithHttpInfo($anio_ini_str, $anio_fin_str, $idema);
        return $response;
    }

    /**
     * Operation climatologasMensualesAnuales_WithHttpInfo
     *
     * Climatologías mensuales anuales.
     *
     * @param  string $anio_ini_str Año Inicial (AAAA) (required)
     * @param  string $anio_fin_str Año Final (AAAA) (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\Model200, HTTP status code, HTTP response headers (array of strings)
     */
    public function climatologasMensualesAnuales_WithHttpInfo($anio_ini_str, $anio_fin_str, $idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasMensualesAnuales_Request($anio_ini_str, $anio_fin_str, $idema);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model401',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model429',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation climatologasMensualesAnuales_Async
     *
     * Climatologías mensuales anuales.
     *
     * @param  string $anio_ini_str Año Inicial (AAAA) (required)
     * @param  string $anio_fin_str Año Final (AAAA) (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasMensualesAnuales_Async($anio_ini_str, $anio_fin_str, $idema)
    {
        return $this->climatologasMensualesAnuales_AsyncWithHttpInfo($anio_ini_str, $anio_fin_str, $idema)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation climatologasMensualesAnuales_AsyncWithHttpInfo
     *
     * Climatologías mensuales anuales.
     *
     * @param  string $anio_ini_str Año Inicial (AAAA) (required)
     * @param  string $anio_fin_str Año Final (AAAA) (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasMensualesAnuales_AsyncWithHttpInfo($anio_ini_str, $anio_fin_str, $idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasMensualesAnuales_Request($anio_ini_str, $anio_fin_str, $idema);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'climatologasMensualesAnuales_'
     *
     * @param  string $anio_ini_str Año Inicial (AAAA) (required)
     * @param  string $anio_fin_str Año Final (AAAA) (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function climatologasMensualesAnuales_Request($anio_ini_str, $anio_fin_str, $idema)
    {
        // verify the required parameter 'anio_ini_str' is set
        if ($anio_ini_str === null || (is_array($anio_ini_str) && count($anio_ini_str) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $anio_ini_str when calling climatologasMensualesAnuales_'
            );
        }
        // verify the required parameter 'anio_fin_str' is set
        if ($anio_fin_str === null || (is_array($anio_fin_str) && count($anio_fin_str) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $anio_fin_str when calling climatologasMensualesAnuales_'
            );
        }
        // verify the required parameter 'idema' is set
        if ($idema === null || (is_array($idema) && count($idema) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $idema when calling climatologasMensualesAnuales_'
            );
        }

        $resourcePath = '/api/valores/climatologicos/mensualesanuales/datos/anioini/{anioIniStr}/aniofin/{anioFinStr}/estacion/{idema}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($anio_ini_str !== null) {
            $resourcePath = str_replace(
                '{' . 'anioIniStr' . '}',
                ObjectSerializer::toPathValue($anio_ini_str),
                $resourcePath
            );
        }
        // path params
        if ($anio_fin_str !== null) {
            $resourcePath = str_replace(
                '{' . 'anioFinStr' . '}',
                ObjectSerializer::toPathValue($anio_fin_str),
                $resourcePath
            );
        }
        // path params
        if ($idema !== null) {
            $resourcePath = str_replace(
                '{' . 'idema' . '}',
                ObjectSerializer::toPathValue($idema),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation climatologasNormales19812010_
     *
     * Climatologías normales (1981-2010).
     *
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\Model200
     */
    public function climatologasNormales19812010_($idema)
    {
        list($response) = $this->climatologasNormales19812010_WithHttpInfo($idema);
        return $response;
    }

    /**
     * Operation climatologasNormales19812010_WithHttpInfo
     *
     * Climatologías normales (1981-2010).
     *
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\Model200, HTTP status code, HTTP response headers (array of strings)
     */
    public function climatologasNormales19812010_WithHttpInfo($idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasNormales19812010_Request($idema);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model401',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model429',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation climatologasNormales19812010_Async
     *
     * Climatologías normales (1981-2010).
     *
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasNormales19812010_Async($idema)
    {
        return $this->climatologasNormales19812010_AsyncWithHttpInfo($idema)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation climatologasNormales19812010_AsyncWithHttpInfo
     *
     * Climatologías normales (1981-2010).
     *
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function climatologasNormales19812010_AsyncWithHttpInfo($idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->climatologasNormales19812010_Request($idema);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'climatologasNormales19812010_'
     *
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function climatologasNormales19812010_Request($idema)
    {
        // verify the required parameter 'idema' is set
        if ($idema === null || (is_array($idema) && count($idema) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $idema when calling climatologasNormales19812010_'
            );
        }

        $resourcePath = '/api/valores/climatologicos/normales/estacion/{idema}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($idema !== null) {
            $resourcePath = str_replace(
                '{' . 'idema' . '}',
                ObjectSerializer::toPathValue($idema),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation estacionesPorIndicativo_
     *
     * Estaciones por indicativo.
     *
     * @param  string $estaciones Listado de indicativos climatológicos (id1,id2,id3,...,idn) (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\Model200
     */
    public function estacionesPorIndicativo_($estaciones)
    {
        list($response) = $this->estacionesPorIndicativo_WithHttpInfo($estaciones);
        return $response;
    }

    /**
     * Operation estacionesPorIndicativo_WithHttpInfo
     *
     * Estaciones por indicativo.
     *
     * @param  string $estaciones Listado de indicativos climatológicos (id1,id2,id3,...,idn) (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\Model200, HTTP status code, HTTP response headers (array of strings)
     */
    public function estacionesPorIndicativo_WithHttpInfo($estaciones)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->estacionesPorIndicativo_Request($estaciones);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model401',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model429',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation estacionesPorIndicativo_Async
     *
     * Estaciones por indicativo.
     *
     * @param  string $estaciones Listado de indicativos climatológicos (id1,id2,id3,...,idn) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function estacionesPorIndicativo_Async($estaciones)
    {
        return $this->estacionesPorIndicativo_AsyncWithHttpInfo($estaciones)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation estacionesPorIndicativo_AsyncWithHttpInfo
     *
     * Estaciones por indicativo.
     *
     * @param  string $estaciones Listado de indicativos climatológicos (id1,id2,id3,...,idn) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function estacionesPorIndicativo_AsyncWithHttpInfo($estaciones)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->estacionesPorIndicativo_Request($estaciones);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'estacionesPorIndicativo_'
     *
     * @param  string $estaciones Listado de indicativos climatológicos (id1,id2,id3,...,idn) (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function estacionesPorIndicativo_Request($estaciones)
    {
        // verify the required parameter 'estaciones' is set
        if ($estaciones === null || (is_array($estaciones) && count($estaciones) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $estaciones when calling estacionesPorIndicativo_'
            );
        }

        $resourcePath = '/api/valores/climatologicos/inventarioestaciones/estaciones/{estaciones}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($estaciones !== null) {
            $resourcePath = str_replace(
                '{' . 'estaciones' . '}',
                ObjectSerializer::toPathValue($estaciones),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation inventarioDeEstacionesValoresClimatolgicos_
     *
     * Inventario de estaciones (valores climatológicos).
     *
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\Model200
     */
    public function inventarioDeEstacionesValoresClimatolgicos_()
    {
        list($response) = $this->inventarioDeEstacionesValoresClimatolgicos_WithHttpInfo();
        return $response;
    }

    /**
     * Operation inventarioDeEstacionesValoresClimatolgicos_WithHttpInfo
     *
     * Inventario de estaciones (valores climatológicos).
     *
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\Model200, HTTP status code, HTTP response headers (array of strings)
     */
    public function inventarioDeEstacionesValoresClimatolgicos_WithHttpInfo()
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->inventarioDeEstacionesValoresClimatolgicos_Request();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model401',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model429',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation inventarioDeEstacionesValoresClimatolgicos_Async
     *
     * Inventario de estaciones (valores climatológicos).
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function inventarioDeEstacionesValoresClimatolgicos_Async()
    {
        return $this->inventarioDeEstacionesValoresClimatolgicos_AsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation inventarioDeEstacionesValoresClimatolgicos_AsyncWithHttpInfo
     *
     * Inventario de estaciones (valores climatológicos).
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function inventarioDeEstacionesValoresClimatolgicos_AsyncWithHttpInfo()
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->inventarioDeEstacionesValoresClimatolgicos_Request();

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'inventarioDeEstacionesValoresClimatolgicos_'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function inventarioDeEstacionesValoresClimatolgicos_Request()
    {

        $resourcePath = '/api/valores/climatologicos/inventarioestaciones/todasestaciones';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation valoresExtremos_
     *
     * Valores extremos.
     *
     * @param  string $parametro | Código | Parámetro Meteorológico | |----------|----------| | P  | Precipitación   | | T  | Temperatura   | | V  | Viento (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Swagger\Client\Model\Model200
     */
    public function valoresExtremos_($parametro, $idema)
    {
        list($response) = $this->valoresExtremos_WithHttpInfo($parametro, $idema);
        return $response;
    }

    /**
     * Operation valoresExtremos_WithHttpInfo
     *
     * Valores extremos.
     *
     * @param  string $parametro | Código | Parámetro Meteorológico | |----------|----------| | P  | Precipitación   | | T  | Temperatura   | | V  | Viento (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Swagger\Client\Model\Model200, HTTP status code, HTTP response headers (array of strings)
     */
    public function valoresExtremos_WithHttpInfo($parametro, $idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->valoresExtremos_Request($parametro, $idema);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model401',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model404',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Swagger\Client\Model\Model429',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation valoresExtremos_Async
     *
     * Valores extremos.
     *
     * @param  string $parametro | Código | Parámetro Meteorológico | |----------|----------| | P  | Precipitación   | | T  | Temperatura   | | V  | Viento (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function valoresExtremos_Async($parametro, $idema)
    {
        return $this->valoresExtremos_AsyncWithHttpInfo($parametro, $idema)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation valoresExtremos_AsyncWithHttpInfo
     *
     * Valores extremos.
     *
     * @param  string $parametro | Código | Parámetro Meteorológico | |----------|----------| | P  | Precipitación   | | T  | Temperatura   | | V  | Viento (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function valoresExtremos_AsyncWithHttpInfo($parametro, $idema)
    {
        $returnType = '\Swagger\Client\Model\Model200';
        $request = $this->valoresExtremos_Request($parametro, $idema);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'valoresExtremos_'
     *
     * @param  string $parametro | Código | Parámetro Meteorológico | |----------|----------| | P  | Precipitación   | | T  | Temperatura   | | V  | Viento (required)
     * @param  string $idema Indicativo climatológico de la EMA (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function valoresExtremos_Request($parametro, $idema)
    {
        // verify the required parameter 'parametro' is set
        if ($parametro === null || (is_array($parametro) && count($parametro) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $parametro when calling valoresExtremos_'
            );
        }
        // verify the required parameter 'idema' is set
        if ($idema === null || (is_array($idema) && count($idema) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $idema when calling valoresExtremos_'
            );
        }

        $resourcePath = '/api/valores/climatologicos/valoresextremos/parametro/{parametro}/estacion/{idema}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($parametro !== null) {
            $resourcePath = str_replace(
                '{' . 'parametro' . '}',
                ObjectSerializer::toPathValue($parametro),
                $resourcePath
            );
        }
        // path params
        if ($idema !== null) {
            $resourcePath = str_replace(
                '{' . 'idema' . '}',
                ObjectSerializer::toPathValue($idema),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
