<?php

namespace Drupal\aemet\Model;

/**
 * Base class for any Aemet Model.
 */
class Base implements AemetModelInterface {

  /**
   * Raw data coming from Aemet.
   *
   * @var array<mixed>
   */
  protected array $data;

  /**
   * Constructs the specific model.
   *
   * @param array $data
   *   Data coming from Aemet.
   */
  public function __construct(array $data) {
    $this->data = $data;
  }

  /**
   * {@inheritdoc}
   */
  public function getRaw() {
    return $this->data;
  }

}
