<?php

namespace Drupal\aemet\Model;

/**
 * Sky status: cloudy, stormy...
 */
class SkyStatus {

  /**
   * Constructs the sky status.
   *
   * @param string $description
   *   Sky description.
   * @param string $value
   *   Sky status formal value.
   */
  public function __construct(protected string $description, protected string $value) {
  }

  /**
   * Gets the description.
   *
   * @return string
   *   Sky status description.
   */
  public function getDescription(): string {
    return $this->description;
  }

  /**
   * Gets the value.
   *
   * @return string
   *   Sky status value.
   */
  public function getValue(): string {
    return $this->value;
  }

}
