<?php

/**
 * @file
 * This file contains no working PHP code; it exists to provide additional
 * documentation for doxygen as well as to document hooks in the standard
 * Drupal manner.
 */

use PracticalAfas\UpdateConnector\UpdateObject;

/**
 * Define custom clients.
 *
 * The keys are cass names; the values are descriptions. The afas_api module
 * configures a client in the settings screen.
 *
 * These client classes are child classes of the PracticalAfas client classes,
 * which can configure and validate their options through the settings screen.
 * A new class can be created and exposed through here if e.g. the standard
 * settings don't work... or if the Curl/SOAP library does not work and a
 * replacement PracticalAFAS client is written to e.g. execute HTTP requests
 * in a different way.
 *
 * This is only required for code that uses the standard afas_api_connection()
 * to get/send data; code that uses their own method is free to initialize
 * their client class in whatever way, not necessarily configured through the
 * standard settings screen.
 */
function hook_afas_api_client_info() {
  return array(
    'MyClient' => t('Some class we wanted to have super special connection settings.'),
    '\MyProject\Myclient' => t('A cient class that (unlike most of D7) has a namespace.'),
  );
}

/**
 * Define custom fields for sending data to afas in 'array' form.
 *
 * Array data will be parsed into a proper payload by UpdateObject; this can
 * have custom fields defined. This hook is called from afas_api_send_data()
 * only when the data to send is an array, because the custom fields only have
 * effect on classes created (with array input) after the custom fields are set.
 */
function hook_afas_api_custom_fields() {
  // To implement custom behavior for certain object types that goes further
  // than custom fields, create a custom child class of UpdateObject. This hook
  // is a good place to set those classes too, by just calling overrideClass():
  UpdateObject::overrideClass('KnContact', '\Myproject\Myclass');

  return array(
    'FbSales' => array(
      'U2080AAAAAAAAAAAAAAAAAAAAAAAAAAAA' => array(
        'alias' => 'some_date',
        'type' => 'date',
        'required' => TRUE,
      ),
      'U2081AAAAAAAAAAAAAAAAAAAAAAAAAAAA' => array(
        'alias' => 'some_number',
        'type' => 'integer',
        'default' => 1,
      ),
    ),
    'KnOrganisation' => array(
      // BTW nummer
      'U2082AAAAAAAAAAAAAAAAAAAAAAAAAAAA' => array(
        'alias' => 'vat_nr',
      ),
      // Regio (verwijzing naar: Tabelwaarde,Regio => AfasKnCodeTableValue)
      'U2083AAAAAAAAAAAAAAAAAAAAAAAAAAAA' => array(
        'alias' => 'region',
      ),
    ),
  );
}
