<?php

use PracticalAfas\Client\RememberCallDataTrait;
use PracticalAfas\Client\SoapAppClient;

/**
 * Subclass of \PracticalAfas\SoapAppClient, handling Drupal configuration.
 */
class DrupalSoapAppClient extends SoapAppClient {
  use ClientCommonSettingsTrait {
      settingsForm as commonSettingsForm;
  }
  use RememberCallDataTrait;

  /**
   * {@inheritdoc}
   */
  public function __construct(array $options = array()) {
    $options = $this->checkCommonSettings($options);

    if (!isset($options['useWSDL'])) {
      $options['useWSDL'] = variable_get('afas_api_use_wsdl', FALSE);
    }
    if ($options['useWSDL']) {
      if (!isset($options['cacheWSDL'])) {
        $options['cacheWSDL'] = variable_get('afas_api_cache_wsdl', 86400);
      }
    }

    parent::__construct($options);
  }

  /**
   * Adds class specific options to the settings form.
   *
   * @return array
   *   Extra form elements to merge into the settings form.
   */
  public static function settingsForm() {
    $form = self::commonSettingsForm();

    $form['afas_api_use_wsdl'] = array(
      '#type' => 'checkbox',
      '#title' => t('Use WSDL'),
      '#description' => t('Not using WSDL is faster / simpler; AFAS calls are simple/static enough not to need WSDL.'),
      '#default_value' => variable_get('afas_api_use_wsdl', FALSE),
    );
    $form['afas_api_cache_wsdl'] = array(
      '#type' => 'select',
      '#title' => t('Cache WSDL file'),
      '#description' => t('How long to keep the WSDL file cached locally, before downloading a fresh copy from the server.'),
      '#options' => array(
        0 => 'Do not cache',
        300 => '5 minutes',
        1800 => '30 minutes',
        3600 => '1 hour',
        14400 => '4 hours',
        86400 => '1 day',
        604800 => '1 week',
        2502000 => '30 days',
      ),
      '#default_value' => variable_get('afas_api_cache_wsdl', 86400),
      '#states' => array('enabled' => array(':input[name="afas_api_use_wsdl"]' =>  array('checked' => TRUE)))
    );

    return $form;
  }

}
