<?php

namespace Drupal\affected_by_promotion;

use Drupal\commerce_promotion\Entity\PromotionInterface;

/**
 * AffectedEntitiesManager service.
 */
class AffectedEntitiesManager {

  /**
   * Get the query for finding the affected entities for a promotion.
   *
   * @param \Drupal\commerce_promotion\Entity\PromotionInterface $promotion
   *   The promotion to use for the query.
   * @param string $entity_type_id
   *   The entity type id. For example commerce_product.
   *
   * @return bool|\Drupal\Core\Database\Query\Query
   *   Return a query if the offer type supports it, FALSE otherwise.
   */
  public function getAffectedEntitiesQuery(PromotionInterface $promotion, $entity_type_id) {
    $offer = $promotion->getOffer();
    if (!$offer instanceof SupportsAffectedEntitiesQueryInterface) {
      return FALSE;
    }
    return $offer->getAffectedEntitiesQuery($entity_type_id);
  }

}
