/**
 * @file
 * JavaScript file for Affiliated tracking.
 */

(function (Drupal, drupalSettings, once) {
  Drupal.behaviors.affiliatedTrack = {
    attach(context, settings) {
      once('affiliated', 'body').forEach(function (element) {
        if (typeof drupalSettings.affiliated !== 'undefined') {
          const urlParams = new URLSearchParams(window.location.search);
          const affiliateCode = urlParams.get(
            drupalSettings.affiliated.affiliate_key,
          );

          if (affiliateCode) {
            const trackData = {
              affiliate: affiliateCode,
              campaign: urlParams.get(drupalSettings.affiliated.campaign_key),
              landingPage: window.location.pathname,
              referrerUrl: document.referrer || '',
            };

            // Convert data object to FormData for POST
            const formData = new FormData();
            Object.keys(trackData).forEach(function (key) {
              if (trackData[key] !== null && trackData[key] !== undefined) {
                formData.append(key, trackData[key]);
              }
            });

            fetch(Drupal.url('affiliated/track'), {
              method: 'POST',
              body: formData,
            });
          }
        }
      });
    },
  };
})(Drupal, drupalSettings, once);
