<?php

namespace Drupal\affiliated\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Access check that requires edit permission on an entity.
 *
 * Used to restrict canonical pages to users who can edit the entity.
 */
class EntityEditAccessCheck implements AccessInterface {

  /**
   * Checks access based on entity edit permission.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The current user.
   * @param \Drupal\Core\Entity\EntityInterface|null $affiliate_click
   *   The affiliate click entity (if on click route).
   * @param \Drupal\Core\Entity\EntityInterface|null $affiliate_conversion
   *   The affiliate conversion entity (if on conversion route).
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(AccountInterface $account, ?EntityInterface $affiliate_click = NULL, ?EntityInterface $affiliate_conversion = NULL) {
    $entity = $affiliate_click ?? $affiliate_conversion;

    if (!$entity) {
      return AccessResult::forbidden();
    }

    // Allow if user can edit the entity.
    return $entity->access('update', $account, TRUE);
  }

}
