<?php

namespace Drupal\affiliated;

use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Provides dynamic permissions for Affiliate Campaign entities.
 *
 * @ingroup affiliated
 */
class AffiliatePermissions {

  use StringTranslationTrait;

  /**
   * Returns an array of permissions.
   */
  public function generatePermissions() {
    // Global Permissions.
    $permissions['create affiliate_campaign entities'] = [
      'title' => $this->t('Create new Affiliate Campaigns'),
    ];
    $permissions['approve affiliate_conversion entities'] = [
      'title' => $this->t('Approve/deny affiliate conversion entities'),
    ];

    // Any / Owner Permissions.
    $scopes = ['any', 'own'];
    foreach ($scopes as $scope) {
      $params = ['%scope' => $scope];
      // Conversions.
      $permissions['view ' . $scope . ' affiliate_conversion entities'] = [
        'title' => $this->t('View %scope affiliate conversion entities', $params),
      ];

      // Campaigns.
      $permissions['view ' . $scope . ' affiliate_campaign entities'] = [
        'title' => $this->t('View %scope affiliate campaign entities', $params),
      ];
      $permissions['edit ' . $scope . ' affiliate_campaign entities'] = [
        'title' => $this->t('Edit %scope affiliate campaign entities', $params),
      ];
      $permissions['delete ' . $scope . ' affiliate_campaign entities'] = [
        'title' => $this->t('Delete %scope affiliate campaign entities', $params),
      ];

      // Clicks / Visits.
      $permissions['view ' . $scope . ' affiliate_click entities'] = [
        'title' => $this->t('View %scope affiliate click entities', $params),
      ];
      $permissions['delete ' . $scope . ' affiliate_click entities'] = [
        'title' => $this->t('Delete %scope affiliate click entities', $params),
      ];
    }
    return $permissions;
  }

}
