<?php

namespace Drupal\affiliated\Event;

// For Drupal 10+ (recommended)
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event that is fired when an affiliate account is looked up.
 */
class AffiliateAccountLookupEvent extends Event {

  // This makes it easier for subscribers to reliably use our event name.
  const EVENT_NAME = 'affiliated_account_lookup';

  /**
   * The user account.
   *
   * @var \Drupal\user\UserInterface
   */
  private $account;

  /**
   * The unique affiliate code to lookup.
   *
   * @var string
   */
  private $code;

  /**
   * Constructs the object.
   *
   * @param string $code
   *   The affiliate code being looked up.
   * @param \Drupal\user\UserInterface|null $account
   *   The account of the affiliate, or NULL if not found.
   */
  public function __construct($code, $account) {
    $this->account = $account;
    $this->code = $code;
  }

  /**
   * Sets the affiliate account.
   *
   * @param \Drupal\user\UserInterface|null $account
   *   The affiliate account.
   *
   * @return \Drupal\user\UserInterface|null
   *   The affiliate account.
   */
  public function setAccount($account) {
    $this->account = $account;
    return $this->account;
  }

  /**
   * Gets the affiliate account.
   *
   * @return \Drupal\user\UserInterface|null
   *   The affiliate account.
   */
  public function getAccount() {
    return $this->account;
  }

  /**
   * Gets the affiliate code.
   *
   * @return string
   *   The affiliate code.
   */
  public function getCode() {
    return $this->code;
  }

}
