<?php

namespace Drupal\affiliated\Event;

// For Drupal 10+ (recommended)
use Drupal\Core\Session\AccountInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event that is fired when an affiliate code is looked up.
 */
class AffiliateCodeLookupEvent extends Event {

  // This makes it easier for subscribers to reliably use our event name.
  const EVENT_NAME = 'affiliated_code_lookup';

  /**
   * The user account.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  private $account;

  /**
   * The unique affiliate code to lookup.
   *
   * @var string
   */
  private $code;

  /**
   * Constructs the object.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The account we are checking.
   * @param string $code
   *   The affiliate code for this account.
   */
  public function __construct(AccountInterface $account, $code) {
    $this->account = $account;
    $this->code = $code;
  }

  /**
   * Sets the affiliate code.
   *
   * @param string $code
   *   The affiliate code.
   *
   * @return string
   *   The affiliate code.
   */
  public function setCode($code): string {
    $this->code = $code;
    return $this->code;
  }

  /**
   * Gets the affiliate account.
   *
   * @return \Drupal\Core\Session\AccountInterface
   *   The affiliate account.
   */
  public function getAccount() {
    return $this->account;
  }

  /**
   * Gets the affiliate code.
   *
   * @return string
   *   The affiliate code.
   */
  public function getCode(): string {
    return $this->code;
  }

}
