<?php

namespace Drupal\affiliated\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Checks that a value is not purely numeric.
 */
#[Constraint(
  id: 'NotNumeric',
  label: new TranslatableMarkup('Not numeric', [], ['context' => 'Validation'])
)]
class NotNumericConstraint extends SymfonyConstraint {

  /**
   * The error message.
   *
   * @var string
   */
  public string $message = 'The value cannot be purely numeric.';

}
