<?php

namespace Drupal\Tests\affiliated\Kernel\Entity;

use Drupal\Tests\affiliated\Kernel\AffiliatedKernelTestBase;

/**
 * Tests the AffiliateCampaign entity.
 *
 * @group affiliated
 * @coversDefaultClass \Drupal\affiliated\Entity\AffiliateCampaign
 */
class AffiliateCampaignTest extends AffiliatedKernelTestBase {

  /**
   * Tests creating a campaign entity.
   */
  public function testCreateCampaign(): void {
    $user = $this->createAffiliateUser();

    $campaign = $this->entityTypeManager->getStorage('affiliate_campaign')->create([
      'user_id' => $user->id(),
      'name' => 'My Campaign',
      'status' => 1,
    ]);
    $campaign->save();

    $this->assertNotEmpty($campaign->id());
    $this->assertEquals('My Campaign', $campaign->label());
    $this->assertTrue($campaign->isPublished());
    $this->assertEquals($user->id(), $campaign->getOwnerId());
  }

  /**
   * Tests the default campaign flag.
   */
  public function testDefaultCampaign(): void {
    $campaign = $this->entityTypeManager->getStorage('affiliate_campaign')->create([
      'user_id' => 0,
      'name' => 'Default Campaign',
      'is_default' => 1,
    ]);
    $campaign->save();

    $this->assertTrue($campaign->isDefault());
  }

  /**
   * Tests setting a new default campaign unsets the old one.
   *
   * The default-unsetting logic only works for user-specific campaigns,
   * not global campaigns (user_id = 0).
   */
  public function testSettingNewDefaultUnsetsOld(): void {
    $user = $this->createAffiliateUser();

    // Create first default for this user.
    $campaign1 = $this->entityTypeManager->getStorage('affiliate_campaign')->create([
      'user_id' => $user->id(),
      'name' => 'First Default',
      'is_default' => 1,
    ]);
    $campaign1->save();

    // Create second default for the same user.
    $campaign2 = $this->entityTypeManager->getStorage('affiliate_campaign')->create([
      'user_id' => $user->id(),
      'name' => 'Second Default',
      'is_default' => 1,
    ]);
    $campaign2->save();

    // Reload first campaign.
    $campaign1 = $this->entityTypeManager->getStorage('affiliate_campaign')->load($campaign1->id());

    $this->assertFalse($campaign1->isDefault());
    $this->assertTrue($campaign2->isDefault());
  }

  /**
   * Tests global campaign (user_id = 0).
   */
  public function testGlobalCampaign(): void {
    $campaign = $this->entityTypeManager->getStorage('affiliate_campaign')->create([
      'user_id' => 0,
      'name' => 'Global Campaign',
    ]);
    $campaign->save();

    $this->assertEquals(0, $campaign->getOwnerId());
  }

  /**
   * Tests unpublished campaign.
   */
  public function testUnpublishedCampaign(): void {
    $campaign = $this->entityTypeManager->getStorage('affiliate_campaign')->create([
      'name' => 'Unpublished Campaign',
      'status' => 0,
    ]);
    $campaign->save();

    $this->assertFalse($campaign->isPublished());
  }

}
