<?php

/**
 * @file
 * Administrative page callbacks for the aframe module.
 */

/**
 * Implements hook_admin_settings() for module settings configuration.
 */
function aframe_admin_settings_form($form_state) {
  $form['aframe_library'] = array(
    '#title' => t('A-frame library'),
    '#type' => 'textfield',
    '#default_value' => variable_get('aframe_library'),
    '#required' => TRUE,
    '#description' => t('Get library url from https://aframe.io'),
  );

  $form['aframe_path'] = array(
    '#title' => t('Path'),
    '#type' => 'textarea',
    '#default_value' => variable_get('aframe_path'),
    '#required' => TRUE,
    '#description' => t('Configure path where aframe is used. One per line.'),
  );

  return system_settings_form($form);
}
